/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai.api;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.springframework.ai.model.ChatModelDescription;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.api.OpenAiStreamFunctionCallingHelper;
import org.springframework.ai.openai.api.ResponseFormat;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OpenAiApi {
    public static final ChatModel DEFAULT_CHAT_MODEL = ChatModel.GPT_4_O;
    public static final String DEFAULT_EMBEDDING_MODEL = EmbeddingModel.TEXT_EMBEDDING_ADA_002.getValue();
    private static final Predicate<String> SSE_DONE_PREDICATE = "[DONE]"::equals;
    private final String completionsPath;
    private final String embeddingsPath;
    private final RestClient restClient;
    private final WebClient webClient;
    private OpenAiStreamFunctionCallingHelper chunkMerger = new OpenAiStreamFunctionCallingHelper();

    public OpenAiApi(String apiKey) {
        this("https://api.openai.com", apiKey);
    }

    public OpenAiApi(String baseUrl, String apiKey) {
        this(baseUrl, apiKey, RestClient.builder(), WebClient.builder());
    }

    public OpenAiApi(String baseUrl, String apiKey, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder) {
        this(baseUrl, apiKey, restClientBuilder, webClientBuilder, RetryUtils.DEFAULT_RESPONSE_ERROR_HANDLER);
    }

    public OpenAiApi(String baseUrl, String apiKey, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this(baseUrl, apiKey, "/v1/chat/completions", "/v1/embeddings", restClientBuilder, webClientBuilder, responseErrorHandler);
    }

    public OpenAiApi(String baseUrl, String apiKey, String completionsPath, String embeddingsPath, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        this(baseUrl, apiKey, (MultiValueMap<String, String>)CollectionUtils.toMultiValueMap(Map.of()), completionsPath, embeddingsPath, restClientBuilder, webClientBuilder, responseErrorHandler);
    }

    public OpenAiApi(String baseUrl, String apiKey, MultiValueMap<String, String> headers, String completionsPath, String embeddingsPath, RestClient.Builder restClientBuilder, WebClient.Builder webClientBuilder, ResponseErrorHandler responseErrorHandler) {
        Assert.hasText((String)completionsPath, (String)"Completions Path must not be null");
        Assert.hasText((String)embeddingsPath, (String)"Embeddings Path must not be null");
        Assert.notNull(headers, (String)"Headers must not be null");
        this.completionsPath = completionsPath;
        this.embeddingsPath = embeddingsPath;
        Consumer<HttpHeaders> finalHeaders = h -> {
            h.setBearerAuth(apiKey);
            h.setContentType(MediaType.APPLICATION_JSON);
            h.addAll(headers);
        };
        this.restClient = restClientBuilder.baseUrl(baseUrl).defaultHeaders(finalHeaders).defaultStatusHandler(responseErrorHandler).build();
        this.webClient = webClientBuilder.baseUrl(baseUrl).defaultHeaders(finalHeaders).build();
    }

    public static String getTextContent(List<ChatCompletionMessage.MediaContent> content) {
        return content.stream().filter(c -> "text".equals(c.type())).map(ChatCompletionMessage.MediaContent::text).reduce("", (a, b) -> a + b);
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest) {
        return this.chatCompletionEntity(chatRequest, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public ResponseEntity<ChatCompletion> chatCompletionEntity(ChatCompletionRequest chatRequest, MultiValueMap<String, String> additionalHttpHeader) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((chatRequest.stream() == false ? 1 : 0) != 0, (String)"Request must set the stream property to false.");
        Assert.notNull(additionalHttpHeader, (String)"The additional HTTP headers can not be null.");
        return ((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.post().uri(this.completionsPath, new Object[0])).headers(headers -> headers.addAll(additionalHttpHeader))).body((Object)chatRequest).retrieve().toEntity(ChatCompletion.class);
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest) {
        return this.chatCompletionStream(chatRequest, (MultiValueMap<String, String>)new LinkedMultiValueMap());
    }

    public Flux<ChatCompletionChunk> chatCompletionStream(ChatCompletionRequest chatRequest, MultiValueMap<String, String> additionalHttpHeader) {
        Assert.notNull((Object)chatRequest, (String)"The request body can not be null.");
        Assert.isTrue((boolean)chatRequest.stream(), (String)"Request must set the stream property to true.");
        AtomicBoolean isInsideTool = new AtomicBoolean(false);
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.post().uri(this.completionsPath, new Object[0])).headers(headers -> headers.addAll(additionalHttpHeader))).body((Publisher)Mono.just((Object)chatRequest), ChatCompletionRequest.class).retrieve().bodyToFlux(String.class).takeUntil(SSE_DONE_PREDICATE).filter(SSE_DONE_PREDICATE.negate()).map(content -> (ChatCompletionChunk)ModelOptionsUtils.jsonToObject((String)content, ChatCompletionChunk.class)).map(chunk -> {
            if (this.chunkMerger.isStreamingToolFunctionCall((ChatCompletionChunk)chunk)) {
                isInsideTool.set(true);
            }
            return chunk;
        }).windowUntil(chunk -> {
            if (isInsideTool.get() && this.chunkMerger.isStreamingToolFunctionCallFinish((ChatCompletionChunk)chunk)) {
                isInsideTool.set(false);
                return true;
            }
            return !isInsideTool.get();
        }).concatMapIterable(window -> {
            Mono monoChunk = window.reduce((Object)new ChatCompletionChunk(null, null, null, null, null, null, null, null), (previous, current) -> this.chunkMerger.merge((ChatCompletionChunk)previous, (ChatCompletionChunk)current));
            return List.of(monoChunk);
        }).flatMap(mono -> mono);
    }

    public <T> ResponseEntity<EmbeddingList<Embedding>> embeddings(EmbeddingRequest<T> embeddingRequest) {
        Assert.notNull(embeddingRequest, (String)"The request body can not be null.");
        Assert.notNull(embeddingRequest.input(), (String)"The input can not be null.");
        Assert.isTrue((embeddingRequest.input() instanceof String || embeddingRequest.input() instanceof List ? 1 : 0) != 0, (String)"The input must be either a String, or a List of Strings or List of List of integers.");
        T t = embeddingRequest.input();
        if (t instanceof List) {
            List list = (List)t;
            Assert.isTrue((!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)"The input list can not be empty.");
            Assert.isTrue((list.size() <= 2048 ? 1 : 0) != 0, (String)"The list must be 2048 dimensions or less");
            Assert.isTrue((list.get(0) instanceof String || list.get(0) instanceof Integer || list.get(0) instanceof List ? 1 : 0) != 0, (String)"The input must be either a String, or a List of Strings or list of list of integers.");
        }
        return ((RestClient.RequestBodySpec)this.restClient.post().uri(this.embeddingsPath, new Object[0])).body(embeddingRequest).retrieve().toEntity((ParameterizedTypeReference)new ParameterizedTypeReference<EmbeddingList<Embedding>>(){});
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionRequest(@JsonProperty(value="messages") List<ChatCompletionMessage> messages, @JsonProperty(value="model") String model, @JsonProperty(value="store") Boolean store, @JsonProperty(value="metadata") Object metadata, @JsonProperty(value="frequency_penalty") Double frequencyPenalty, @JsonProperty(value="logit_bias") Map<String, Integer> logitBias, @JsonProperty(value="logprobs") Boolean logprobs, @JsonProperty(value="top_logprobs") Integer topLogprobs, @JsonProperty(value="max_tokens") @Deprecated Integer maxTokens, @JsonProperty(value="max_completion_tokens") Integer maxCompletionTokens, @JsonProperty(value="n") Integer n, @JsonProperty(value="modalities") List<OutputModality> outputModalities, @JsonProperty(value="audio") AudioParameters audioParameters, @JsonProperty(value="presence_penalty") Double presencePenalty, @JsonProperty(value="response_format") ResponseFormat responseFormat, @JsonProperty(value="seed") Integer seed, @JsonProperty(value="service_tier") String serviceTier, @JsonProperty(value="stop") List<String> stop, @JsonProperty(value="stream") Boolean stream, @JsonProperty(value="stream_options") StreamOptions streamOptions, @JsonProperty(value="temperature") Double temperature, @JsonProperty(value="top_p") Double topP, @JsonProperty(value="tools") List<FunctionTool> tools, @JsonProperty(value="tool_choice") Object toolChoice, @JsonProperty(value="parallel_tool_calls") Boolean parallelToolCalls, @JsonProperty(value="user") String user) {
        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature) {
            this(messages, model, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, temperature, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, AudioParameters audio, boolean stream) {
            this(messages, model, null, null, null, null, null, null, null, null, null, List.of(OutputModality.AUDIO, OutputModality.TEXT), audio, null, null, null, null, null, stream, null, null, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, Double temperature, boolean stream) {
            this(messages, model, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, stream, null, temperature, null, null, null, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, String model, List<FunctionTool> tools, Object toolChoice) {
            this(messages, model, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, 0.8, null, tools, toolChoice, null, null);
        }

        public ChatCompletionRequest(List<ChatCompletionMessage> messages, Boolean stream) {
            this(messages, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, stream, null, null, null, null, null, null, null);
        }

        public ChatCompletionRequest streamOptions(StreamOptions streamOptions) {
            return new ChatCompletionRequest(this.messages, this.model, this.store, this.metadata, this.frequencyPenalty, this.logitBias, this.logprobs, this.topLogprobs, this.maxTokens, this.maxCompletionTokens, this.n, this.outputModalities, this.audioParameters, this.presencePenalty, this.responseFormat, this.seed, this.serviceTier, this.stop, this.stream, streamOptions, this.temperature, this.topP, this.tools, this.toolChoice, this.parallelToolCalls, this.user);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record AudioParameters(@JsonProperty(value="voice") Voice voice, @JsonProperty(value="format") AudioResponseFormat format) {

            public static enum Voice {
                ALLOY,
                ECHO,
                FABLE,
                ONYX,
                NOVA,
                SHIMMER;

            }

            public static enum AudioResponseFormat {
                MP3,
                FLAC,
                OPUS,
                PCM16,
                WAV;

            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record StreamOptions(@JsonProperty(value="include_usage") Boolean includeUsage) {
            public static StreamOptions INCLUDE_USAGE = new StreamOptions(true);
        }

        public static class ToolChoiceBuilder {
            public static final String AUTO = "auto";
            public static final String NONE = "none";

            public static Object FUNCTION(String functionName) {
                return Map.of("type", "function", "function", Map.of("name", functionName));
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletion(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<Choice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="service_tier") String serviceTier, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Choice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="message") ChatCompletionMessage message, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingRequest<T>(@JsonProperty(value="input") T input, @JsonProperty(value="model") String model, @JsonProperty(value="encoding_format") String encodingFormat, @JsonProperty(value="dimensions") Integer dimensions, @JsonProperty(value="user") String user) {
        public EmbeddingRequest(T input, String model) {
            this(input, model, "float", null, null);
        }

        public EmbeddingRequest(T input) {
            this(input, DEFAULT_EMBEDDING_MODEL);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionChunk(@JsonProperty(value="id") String id, @JsonProperty(value="choices") List<ChunkChoice> choices, @JsonProperty(value="created") Long created, @JsonProperty(value="model") String model, @JsonProperty(value="service_tier") String serviceTier, @JsonProperty(value="system_fingerprint") String systemFingerprint, @JsonProperty(value="object") String object, @JsonProperty(value="usage") Usage usage) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChunkChoice(@JsonProperty(value="finish_reason") ChatCompletionFinishReason finishReason, @JsonProperty(value="index") Integer index, @JsonProperty(value="delta") ChatCompletionMessage delta, @JsonProperty(value="logprobs") LogProbs logprobs) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Usage(@JsonProperty(value="completion_tokens") Integer completionTokens, @JsonProperty(value="prompt_tokens") Integer promptTokens, @JsonProperty(value="total_tokens") Integer totalTokens, @JsonProperty(value="prompt_tokens_details") PromptTokensDetails promptTokensDetails, @JsonProperty(value="completion_tokens_details") CompletionTokenDetails completionTokenDetails) {
        public Usage(Integer completionTokens, Integer promptTokens, Integer totalTokens) {
            this(completionTokens, promptTokens, totalTokens, null, null);
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record PromptTokensDetails(@JsonProperty(value="audio_tokens") Integer audioTokens, @JsonProperty(value="cached_tokens") Integer cachedTokens) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonIgnoreProperties(ignoreUnknown=true)
        public record CompletionTokenDetails(@JsonProperty(value="reasoning_tokens") Integer reasoningTokens, @JsonProperty(value="accepted_prediction_tokens") Integer acceptedPredictionTokens, @JsonProperty(value="audio_tokens") Integer audioTokens, @JsonProperty(value="rejected_prediction_tokens") Integer rejectedPredictionTokens) {
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record ChatCompletionMessage(@JsonProperty(value="content") Object rawContent, @JsonProperty(value="role") Role role, @JsonProperty(value="name") String name, @JsonProperty(value="tool_call_id") String toolCallId, @JsonProperty(value="tool_calls") @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}) List<ToolCall> toolCalls, @JsonProperty(value="refusal") String refusal, @JsonProperty(value="audio") AudioOutput audioOutput) {
        public ChatCompletionMessage(Object content, Role role) {
            this(content, role, null, null, null, null, null);
        }

        public String content() {
            if (this.rawContent == null) {
                return null;
            }
            Object object = this.rawContent;
            if (object instanceof String) {
                String text = (String)object;
                return text;
            }
            throw new IllegalStateException("The content is not a string!");
        }

        public static enum Role {
            SYSTEM,
            USER,
            ASSISTANT,
            TOOL;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record AudioOutput(@JsonProperty(value="id") String id, @JsonProperty(value="data") String data, @JsonProperty(value="expires_at") Long expiresAt, @JsonProperty(value="transcript") String transcript) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ChatCompletionFunction(@JsonProperty(value="name") String name, @JsonProperty(value="arguments") String arguments) {
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record ToolCall(@JsonProperty(value="index") Integer index, @JsonProperty(value="id") String id, @JsonProperty(value="type") String type, @JsonProperty(value="function") ChatCompletionFunction function) {
            public ToolCall(String id, String type, ChatCompletionFunction function) {
                this(null, id, type, function);
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record MediaContent(@JsonProperty(value="type") String type, @JsonProperty(value="text") String text, @JsonProperty(value="image_url") ImageUrl imageUrl, @JsonProperty(value="input_audio") InputAudio inputAudio) {
            public MediaContent(String text) {
                this("text", text, null, null);
            }

            public MediaContent(ImageUrl imageUrl) {
                this("image_url", null, imageUrl, null);
            }

            public MediaContent(InputAudio inputAudio) {
                this("input_audio", null, null, inputAudio);
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record ImageUrl(@JsonProperty(value="url") String url, @JsonProperty(value="detail") String detail) {
                public ImageUrl(String url) {
                    this(url, null);
                }
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record InputAudio(@JsonProperty(value="data") String data, @JsonProperty(value="format") Format format) {

                public static enum Format {
                    MP3,
                    WAV;

                }
            }
        }
    }

    public static enum ChatModel implements ChatModelDescription
    {
        O1_PREVIEW("o1-preview"),
        O1_PREVIEW_2024_09_12("o1-preview-2024-09-12"),
        O1_MINI("o1-mini"),
        O1_MINI_2024_09_12("o1-mini-2024-09-12"),
        GPT_4_O("gpt-4o"),
        GPT_4_O_AUDIO_PREVIEW("gpt-4o-audio-preview"),
        GPT_4_O_MINI("gpt-4o-mini"),
        GPT_4_TURBO("gpt-4-turbo"),
        GPT_4_TURBO_2024_04_09("gpt-4-turbo-2024-04-09"),
        GPT_4_0125_PREVIEW("gpt-4-0125-preview"),
        GPT_4_TURBO_PREVIEW("gpt-4-turbo-preview"),
        GPT_4("gpt-4"),
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_0125("gpt-3.5-turbo-0125"),
        GPT_3_5_TURBO_1106("gpt-3.5-turbo-1106");

        public final String value;

        private ChatModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String getName() {
            return this.value;
        }
    }

    public static enum EmbeddingModel {
        TEXT_EMBEDDING_3_LARGE("text-embedding-3-large"),
        TEXT_EMBEDDING_3_SMALL("text-embedding-3-small"),
        TEXT_EMBEDDING_ADA_002("text-embedding-ada-002");

        public final String value;

        private EmbeddingModel(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record EmbeddingList<T>(@JsonProperty(value="object") String object, @JsonProperty(value="data") List<T> data, @JsonProperty(value="model") String model, @JsonProperty(value="usage") Usage usage) {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record Embedding(@JsonProperty(value="index") Integer index, @JsonProperty(value="embedding") float[] embedding, @JsonProperty(value="object") String object) {
        public Embedding(Integer index, float[] embedding) {
            this(index, embedding, "embedding");
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public record LogProbs(@JsonProperty(value="content") List<Content> content, @JsonProperty(value="refusal") List<Content> refusal) {

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public record Content(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes, @JsonProperty(value="top_logprobs") List<TopLogProbs> topLogprobs) {

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public record TopLogProbs(@JsonProperty(value="token") String token, @JsonProperty(value="logprob") Float logprob, @JsonProperty(value="bytes") List<Integer> probBytes) {
            }
        }
    }

    public static enum OutputModality {
        AUDIO,
        TEXT;

    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FunctionTool {
        @JsonProperty(value="type")
        private Type type = Type.FUNCTION;
        @JsonProperty(value="function")
        private Function function;

        public FunctionTool() {
        }

        public FunctionTool(Type type, Function function) {
            this.type = type;
            this.function = function;
        }

        public FunctionTool(Function function) {
            this(Type.FUNCTION, function);
        }

        public Type getType() {
            return this.type;
        }

        public Function getFunction() {
            return this.function;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setFunction(Function function) {
            this.function = function;
        }

        public static enum Type {
            FUNCTION;

        }

        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public static class Function {
            @JsonProperty(value="description")
            private String description;
            @JsonProperty(value="name")
            private String name;
            @JsonProperty(value="parameters")
            private Map<String, Object> parameters;
            @JsonProperty(value="strict")
            Boolean strict;
            @JsonIgnore
            private String jsonSchema;

            private Function() {
            }

            public Function(String description, String name, Map<String, Object> parameters, Boolean strict) {
                this.description = description;
                this.name = name;
                this.parameters = parameters;
                this.strict = strict;
            }

            public Function(String description, String name, String jsonSchema) {
                this(description, name, ModelOptionsUtils.jsonToMap((String)jsonSchema), null);
            }

            public String getDescription() {
                return this.description;
            }

            public String getName() {
                return this.name;
            }

            public Map<String, Object> getParameters() {
                return this.parameters;
            }

            public void setDescription(String description) {
                this.description = description;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setParameters(Map<String, Object> parameters) {
                this.parameters = parameters;
            }

            public Boolean getStrict() {
                return this.strict;
            }

            public void setStrict(Boolean strict) {
                this.strict = strict;
            }

            public String getJsonSchema() {
                return this.jsonSchema;
            }

            public void setJsonSchema(String jsonSchema) {
                this.jsonSchema = jsonSchema;
                if (jsonSchema != null) {
                    this.parameters = ModelOptionsUtils.jsonToMap((String)jsonSchema);
                }
            }
        }
    }

    public static enum ChatCompletionFinishReason {
        STOP,
        LENGTH,
        CONTENT_FILTER,
        TOOL_CALLS,
        TOOL_CALL;

    }
}

