/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mcp.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.server.transport.WebMvcSseServerTransport;
import io.modelcontextprotocol.spec.ServerMcpTransport;
import org.springframework.ai.autoconfigure.mcp.server.McpServerProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.function.ServerResponse;

@AutoConfiguration
@ConditionalOnClass(value={WebMvcSseServerTransport.class})
@ConditionalOnMissingBean(value={ServerMcpTransport.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.server", name={"stdio"}, havingValue="false", matchIfMissing=true)
public class MpcWebMvcServerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WebMvcSseServerTransport webMvcSseServerTransport(ObjectMapper objectMapper, McpServerProperties serverProperties) {
        return new WebMvcSseServerTransport(objectMapper, serverProperties.getSseMessageEndpoint());
    }

    @Bean
    public RouterFunction<ServerResponse> mvcMcpRouterFunction(WebMvcSseServerTransport transport) {
        return transport.getRouterFunction();
    }
}

