/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.openapi.gradle.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.awaitility.Durations;
import org.awaitility.core.ConditionFactory;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.kotlin.AwaitilityKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.springdoc.openapi.gradle.plugin.OpenApiExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0007J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0002J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u001f\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0019\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0007R\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007\u00a8\u0006%"}, d2={"Lorg/springdoc/openapi/gradle/plugin/OpenApiGeneratorTask;", "Lorg/gradle/api/DefaultTask;", "()V", "apiDocsUrl", "Lorg/gradle/api/provider/Property;", "", "getApiDocsUrl", "()Lorg/gradle/api/provider/Property;", "groupedApiMappings", "Lorg/gradle/api/provider/MapProperty;", "getGroupedApiMappings", "()Lorg/gradle/api/provider/MapProperty;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "outputFileName", "getOutputFileName", "requestHeaders", "getRequestHeaders", "trustStore", "getTrustStore", "trustStorePassword", "", "getTrustStorePassword", "waitTimeInSeconds", "", "getWaitTimeInSeconds", "execute", "", "generateApiDocs", "url", "fileName", "getCustomSslContext", "Ljavax/net/ssl/SSLContext;", "prettifyJson", "response", "springdoc-openapi-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nOpenApiGeneratorTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiGeneratorTask.kt\norg/springdoc/openapi/gradle/plugin/OpenApiGeneratorTask\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,172:1\n215#2,2:173\n*S KotlinDebug\n*F\n+ 1 OpenApiGeneratorTask.kt\norg/springdoc/openapi/gradle/plugin/OpenApiGeneratorTask\n*L\n120#1:173,2\n*E\n"})
public class OpenApiGeneratorTask
extends DefaultTask {
    @NotNull
    private final Property<String> apiDocsUrl;
    @NotNull
    private final Property<String> outputFileName;
    @NotNull
    private final MapProperty<String, String> groupedApiMappings;
    @NotNull
    private final MapProperty<String, String> requestHeaders;
    @NotNull
    private final DirectoryProperty outputDir;
    @NotNull
    private final Property<Integer> waitTimeInSeconds;
    @NotNull
    private final Property<String> trustStore;
    @NotNull
    private final Property<char[]> trustStorePassword;

    public OpenApiGeneratorTask() {
        Property property = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(String::class.java)");
        this.apiDocsUrl = property;
        Property property2 = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property(String::class.java)");
        this.outputFileName = property2;
        MapProperty mapProperty = this.getProject().getObjects().mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty, (String)"project.objects.mapPrope\u2026java, String::class.java)");
        this.groupedApiMappings = mapProperty;
        MapProperty mapProperty2 = this.getProject().getObjects().mapProperty(String.class, String.class);
        Intrinsics.checkNotNullExpressionValue((Object)mapProperty2, (String)"project.objects.mapPrope\u2026java, String::class.java)");
        this.requestHeaders = mapProperty2;
        DirectoryProperty directoryProperty = this.getProject().getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"project.objects.directoryProperty()");
        this.outputDir = directoryProperty;
        Property property3 = this.getProject().getObjects().property(Integer.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property(Int::class.java)");
        this.waitTimeInSeconds = property3;
        Property property4 = this.getProject().getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"project.objects.property(String::class.java)");
        this.trustStore = property4;
        Property property5 = this.getProject().getObjects().property(char[].class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"project.objects.property(CharArray::class.java)");
        this.trustStorePassword = property5;
        this.setDescription("Generates the spring doc openapi file");
        this.setGroup("OpenApi");
        Object object = this.getProject().getExtensions().getByName("openApi");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.springdoc.openapi.gradle.plugin.OpenApiExtension");
        OpenApiExtension extension = (OpenApiExtension)object;
        this.apiDocsUrl.convention((Provider)extension.getApiDocsUrl());
        this.outputFileName.convention((Provider)extension.getOutputFileName());
        this.groupedApiMappings.convention((Provider)extension.getGroupedApiMappings());
        this.outputDir.convention((Provider)extension.getOutputDir());
        this.waitTimeInSeconds.convention((Provider)extension.getWaitTimeInSeconds());
        this.trustStore.convention((Provider)extension.getTrustStore());
        this.trustStorePassword.convention((Provider)extension.getTrustStorePassword());
        this.requestHeaders.convention((Provider)extension.getRequestHeaders());
    }

    @Input
    @NotNull
    public final Property<String> getApiDocsUrl() {
        return this.apiDocsUrl;
    }

    @Input
    @NotNull
    public final Property<String> getOutputFileName() {
        return this.outputFileName;
    }

    @Input
    @NotNull
    public final MapProperty<String, String> getGroupedApiMappings() {
        return this.groupedApiMappings;
    }

    @Input
    @NotNull
    public final MapProperty<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getOutputDir() {
        return this.outputDir;
    }

    @Internal
    @NotNull
    public final Property<Integer> getWaitTimeInSeconds() {
        return this.waitTimeInSeconds;
    }

    @Optional
    @Input
    @NotNull
    public final Property<String> getTrustStore() {
        return this.trustStore;
    }

    @Optional
    @Input
    @NotNull
    public final Property<char[]> getTrustStorePassword() {
        return this.trustStorePassword;
    }

    /*
     * Enabled aggressive block sorting
     */
    @TaskAction
    public final void execute() {
        if (this.groupedApiMappings.isPresent()) {
            Object object = this.groupedApiMappings.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"groupedApiMappings.get()");
            if (!((Map)object).isEmpty()) {
                ((Map)this.groupedApiMappings.get()).forEach((arg_0, arg_1) -> OpenApiGeneratorTask.execute$lambda$0((Function2)new Function2<String, String, Unit>((Object)this){

                    public final void invoke(@NotNull String p0, @NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        OpenApiGeneratorTask.access$generateApiDocs((OpenApiGeneratorTask)((Object)this.receiver), p0, p1);
                    }
                }, arg_0, arg_1));
                return;
            }
        }
        Object object = this.apiDocsUrl.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiDocsUrl.get()");
        String string = (String)object;
        Object object2 = this.outputFileName.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"outputFileName.get()");
        this.generateApiDocs(string, (String)object2);
    }

    private final void generateApiDocs(String url, String fileName) {
        try {
            CharSequence charSequence = url;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string = charSequence.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(locale)");
            charSequence = string;
            boolean isYaml = new Regex(".+[./]yaml(/.+)*").matches(charSequence);
            SSLContext sslContext = this.getCustomSslContext();
            ConditionFactory conditionFactory = AwaitilityKt.ignoreException((ConditionFactory)AwaitilityKt.getAwait(), (KClass)Reflection.getOrCreateKotlinClass(ConnectException.class));
            Duration duration = Durations.ONE_SECOND;
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ONE_SECOND");
            ConditionFactory conditionFactory2 = AwaitilityKt.withPollInterval((ConditionFactory)conditionFactory, (Duration)duration);
            Duration duration2 = Duration.of(((Number)this.waitTimeInSeconds.get()).intValue(), ChronoUnit.SECONDS);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"of(\n\t\t\t\twaitTimeInSecond\u2026oLong(),\n\t\t\t\tSECONDS\n\t\t\t)");
            AwaitilityKt.until((ConditionFactory)AwaitilityKt.atMost((ConditionFactory)conditionFactory2, (Duration)duration2), (Function0)((Function0)new Function0<Boolean>(sslContext, url, this){
                final /* synthetic */ SSLContext $sslContext;
                final /* synthetic */ String $url;
                final /* synthetic */ OpenApiGeneratorTask this$0;
                {
                    this.$sslContext = $sslContext;
                    this.$url = $url;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    HttpsURLConnection.setDefaultSSLSocketFactory(this.$sslContext.getSocketFactory());
                    URLConnection uRLConnection = new URL(this.$url).openConnection();
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                    connection.setRequestMethod("GET");
                    Object object = this.this$0.getRequestHeaders().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requestHeaders.get()");
                    Map $this$forEach$iv = (Map)object;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> header = element$iv = iterator.next();
                        boolean bl = false;
                        connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
                    }
                    connection.connect();
                    int statusCode = connection.getResponseCode();
                    this.this$0.getLogger().trace("apiDocsUrl = {} status code = {}", (Object)this.$url, (Object)statusCode);
                    return statusCode < 299;
                }
            }));
            this.getLogger().info("Generating OpenApi Docs..");
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            URLConnection uRLConnection = new URL(url).openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            HttpURLConnection connection = (HttpURLConnection)uRLConnection;
            connection.setRequestMethod("GET");
            Object object = this.requestHeaders.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"requestHeaders.get()");
            Map $this$forEach$iv = (Map)object;
            boolean $i$f$forEach22 = false;
            Object object2 = $this$forEach$iv.entrySet().iterator();
            while (object2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry header = element$iv = object2.next();
                boolean bl = false;
                connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
            }
            connection.connect();
            InputStream inputStream = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
            byte[] $i$f$forEach22 = ByteStreamsKt.readBytes((InputStream)inputStream);
            object2 = Charsets.UTF_8;
            String response = new String($i$f$forEach22, (Charset)object2);
            String apiDocs = isYaml ? response : this.prettifyJson(response);
            File outputFile = ((RegularFile)this.outputDir.file(fileName).get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)outputFile, (String)"outputFile");
            FilesKt.writeText$default((File)outputFile, (String)apiDocs, null, (int)2, null);
        }
        catch (ConditionTimeoutException e) {
            this.getLogger().error("Unable to connect to " + url + " waited for " + this.waitTimeInSeconds.get() + " seconds", (Throwable)e);
            throw new GradleException("Unable to connect to " + url + " waited for " + this.waitTimeInSeconds.get() + " seconds");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SSLContext getCustomSslContext() {
        if (this.trustStore.isPresent()) {
            this.getLogger().debug("Reading truststore: " + (String)this.trustStore.get());
            Closeable closeable = new FileInputStream((String)this.trustStore.get());
            Throwable throwable = null;
            try {
                FileInputStream truststoreFile = (FileInputStream)closeable;
                boolean bl = false;
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore truststore = KeyStore.getInstance(KeyStore.getDefaultType());
                truststore.load(truststoreFile, (char[])this.trustStorePassword.get());
                trustManagerFactory.init(truststore);
                SSLContext sSLContext = SSLContext.getInstance("TLSv1.2");
                Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"getInstance(\"TLSv1.2\")");
                SSLContext sslContext = sSLContext;
                KeyManager[] keyManagers = new KeyManager[]{};
                sslContext.init(keyManagers, trustManagerFactory.getTrustManagers(), new SecureRandom());
                SSLContext sSLContext2 = sslContext;
                return sSLContext2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        SSLContext sSLContext = SSLContext.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)sSLContext, (String)"getDefault()");
        return sSLContext;
    }

    private final String prettifyJson(String response) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            JsonObject googleJsonObject = (JsonObject)gson.fromJson(response, JsonObject.class);
            String string = gson.toJson((JsonElement)googleJsonObject);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(googleJsonObject)");
            return string;
        }
        catch (RuntimeException e) {
            throw new JsonSyntaxException("Failed to parse the API docs response string. Please ensure that the response is in the correct format. response=" + response, (Throwable)e);
        }
    }

    private static final void execute$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ void access$generateApiDocs(OpenApiGeneratorTask $this, String url, String fileName) {
        $this.generateApiDocs(url, fileName);
    }
}

