/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.core.SwaggerUiOAuthProperties;
import org.springframework.util.CollectionUtils;

public class AbstractSwaggerIndexTransformer {
    private static final String PRESETS = "presets: [";
    protected SwaggerUiOAuthProperties swaggerUiOAuthProperties;
    protected ObjectMapper objectMapper;
    protected SwaggerUiConfigProperties swaggerUiConfig;

    public AbstractSwaggerIndexTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, ObjectMapper objectMapper) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.swaggerUiOAuthProperties = swaggerUiOAuthProperties;
        this.objectMapper = objectMapper;
    }

    protected String addInitOauth(String html) throws JsonProcessingException {
        StringBuilder stringBuilder = new StringBuilder("window.ui = ui\n");
        stringBuilder.append("ui.initOAuth(\n");
        String json = this.objectMapper.writeValueAsString(this.swaggerUiOAuthProperties.getConfigParameters());
        stringBuilder.append(json);
        stringBuilder.append(")");
        return html.replace("window.ui = ui", stringBuilder.toString());
    }

    protected String readFullyAsString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    protected String overwriteSwaggerDefaultUrl(String html) {
        return html.replace("https://petstore.swagger.io/v2/swagger.json", "");
    }

    protected boolean hasDefaultTransformations() {
        boolean oauth2Configured = !CollectionUtils.isEmpty(this.swaggerUiOAuthProperties.getConfigParameters());
        return oauth2Configured || this.swaggerUiConfig.isDisableSwaggerDefaultUrl() || this.swaggerUiConfig.isCsrfEnabled() || this.swaggerUiConfig.getSyntaxHighlight() != null;
    }

    protected String defaultTransformations(InputStream inputStream) throws IOException {
        String html = this.readFullyAsString(inputStream);
        if (!CollectionUtils.isEmpty(this.swaggerUiOAuthProperties.getConfigParameters())) {
            html = this.addInitOauth(html);
        }
        if (this.swaggerUiConfig.isDisableSwaggerDefaultUrl()) {
            html = this.overwriteSwaggerDefaultUrl(html);
        }
        if (this.swaggerUiConfig.isCsrfEnabled()) {
            html = this.swaggerUiConfig.getCsrf().isUseLocalStorage() ? this.addCSRFLocalStorage(html) : this.addCSRF(html);
        }
        if (this.swaggerUiConfig.getSyntaxHighlight() != null) {
            html = this.addSyntaxHighlight(html);
        }
        return html;
    }

    protected String addCSRF(String html) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("requestInterceptor: (request) => {\n");
        stringBuilder.append("const value = `; ${document.cookie}`;\n");
        stringBuilder.append("const parts = value.split(`; ");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getCookieName());
        stringBuilder.append("=`);\n");
        stringBuilder.append("if (parts.length === 2)\n");
        stringBuilder.append("request.headers['");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getHeaderName());
        stringBuilder.append("'] = parts.pop().split(';').shift();\n");
        stringBuilder.append("return request;\n");
        stringBuilder.append("},\n");
        stringBuilder.append(PRESETS);
        return html.replace(PRESETS, stringBuilder.toString());
    }

    protected String addCSRFLocalStorage(String html) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("requestInterceptor: (request) => {\n");
        stringBuilder.append("const value = window.localStorage.getItem('");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getLocalStorageKey() + "');\n");
        stringBuilder.append("request.headers['");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getHeaderName());
        stringBuilder.append("'] = value;\n");
        stringBuilder.append("return request;\n");
        stringBuilder.append("},\n");
        stringBuilder.append(PRESETS);
        return html.replace(PRESETS, stringBuilder.toString());
    }

    protected String addSyntaxHighlight(String html) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("syntaxHighlight: {");
        if (this.swaggerUiConfig.getSyntaxHighlight().getActivated() != null) {
            stringBuilder.append("activated: ");
            stringBuilder.append(this.swaggerUiConfig.getSyntaxHighlight().getActivated());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfig.getSyntaxHighlight().getTheme())) {
            if (this.swaggerUiConfig.getSyntaxHighlight().getActivated() != null) {
                stringBuilder.append(" , ");
            }
            stringBuilder.append("theme: \"");
            stringBuilder.append(this.swaggerUiConfig.getSyntaxHighlight().getTheme());
            stringBuilder.append("\"");
        }
        stringBuilder.append("},\n");
        stringBuilder.append(PRESETS);
        return html.replace(PRESETS, stringBuilder.toString());
    }
}

