/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.File;
import java.net.URI;
import org.specs2.control.Exceptions$;
import org.specs2.io.Path;
import org.specs2.io.Paths;
import org.specs2.text.Trim$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class Paths$class {
    public static Path toPath(Paths $this, String s) {
        return new Path(s);
    }

    public static String absoluteDirPath(Paths $this, String s) {
        return $this.toPath(new File(s).getAbsolutePath()).dirPath();
    }

    public static String dirPath(Paths $this, String s) {
        String normalized = $this.toPath(s).normalize();
        return normalized.endsWith("/") ? normalized : new StringBuilder().append((Object)normalized).append((Object)"/").toString();
    }

    public static String fileName(Paths $this, String p) {
        return new File(p).getName();
    }

    public static String unixize(Paths $this, String s) {
        return s.replace("\\", "/");
    }

    public static String normalize(Paths $this, String s) {
        return Trim$.MODULE$.trimmed($this.toPath(s).unixize()).removeFirst("\\./");
    }

    public static String baseDir(Paths $this, String s) {
        return new StringBuilder().append((Object)"./").append((Object)new StringOps(Predef$.MODULE$.augmentString("../")).$times(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])$this.toPath(s).normalize().split("/")).filterNot((Function1)new Serializable($this){

            public final boolean apply(String x$1) {
                return x$1.isEmpty();
            }
        })).size() - 1)).toString();
    }

    public static String parentDir(Paths $this, String s) {
        return $this.toPath((String)Option$.MODULE$.apply((Object)new File($this.toPath(s).normalize()).getParent()).getOrElse((Function0)new Serializable($this){

            public final String apply() {
                return "";
            }
        })).dirPath();
    }

    public static String rebase(Paths $this, String s, String dir) {
        return new StringBuilder().append((Object)$this.toPath(dir).dirPath()).append((Object)new File(s).getName()).toString();
    }

    public static String uriEncode(Paths $this, String url) {
        return (String)Exceptions$.MODULE$.tryo(new Serializable($this, url){
            private final String url$1;

            public final String apply() {
                return new URI("http", "", new StringBuilder().append((Object)"/").append((Object)this.url$1).toString(), null).toASCIIString().replace("http:///", "");
            }
            {
                this.url$1 = url$1;
            }
        }, (Function1<Exception, BoxedUnit>)new Serializable($this){

            public final void apply(Object t) {
                Exceptions$.MODULE$.implicitUnit(t);
            }
        }).getOrElse((Function0)new Serializable($this, url){
            private final String url$1;

            public final String apply() {
                return this.url$1;
            }
            {
                this.url$1 = url$1;
            }
        });
    }

    public static boolean isRelative(Paths $this, String s) {
        String string = $this.toPath(s).unixize();
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"./", "../"}))).exists((Function1)new Serializable($this, string){
            private final String eta$0$1$1;

            public final boolean apply(String x$1) {
                return this.eta$0$1$1.startsWith(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public static String relativeTo(Paths $this, String p1, String p2) {
        return $this.toPath(new StringBuilder().append((Object)$this.toPath(p2).baseDir()).append((Object)p1).toString()).normalize();
    }

    public static String unrelativeTo(Paths $this, String p1, String p2) {
        return $this.toPath(p1).isRelative() ? new StringBuilder().append((Object)$this.toPath(p2).parentDir()).append((Object)$this.toPath(p1).fileName()).toString() : p1;
    }

    public static String fromTop(Paths $this, String s) {
        return $this.relativeTo(s, s);
    }

    public static Function1 from(Paths $this, String base) {
        return new Serializable($this, base){
            private final String base$1;

            public final String apply(String x$2) {
                return x$2.replaceFirst(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\\\Q", "\\\\E/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.base$1})), "");
            }
            {
                this.base$1 = base$1;
            }
        };
    }

    public static void $init$(Paths $this) {
    }
}

