/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.io.FileSystem;
import org.specs2.io.FileSystem$$anonfun$org$specs2$io$FileSystem$;
import org.specs2.io.Paths$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class FileSystem$class {
    public static Seq filePaths(FileSystem $this, String basePath, String path, boolean verbose) {
        Stream found = FileSystem$class.org$specs2$io$FileSystem$$recurse($this, new File(basePath));
        if (verbose) {
            found.foreach((Function1)new Serializable($this){

                public final void apply(File f) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"found file: ").append((Object)f).toString());
                }
            });
        }
        return $this.filterFiles((Seq<File>)found, path, verbose);
    }

    public static String filePaths$default$1(FileSystem $this) {
        return ".";
    }

    public static String filePaths$default$2(FileSystem $this) {
        return "*";
    }

    public static boolean filePaths$default$3(FileSystem $this) {
        return false;
    }

    public static Seq filterFiles(FileSystem $this, Seq found, String path, boolean verbose) {
        String pattern = new StringBuilder().append((Object)$this.globToPattern(path)).append((Object)($this.isDir(path) ? "/*.*" : "")).toString();
        if (verbose) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"\nThe pattern used to match files is: ").append((Object)pattern).toString());
        }
        return ((SeqLike)found.collect((PartialFunction)new Serializable($this, pattern, verbose){
            private final /* synthetic */ FileSystem $outer;
            private final String pattern$1;
            private final boolean verbose$1;

            public final <A1 extends File, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = FileSystem$class.org$specs2$io$FileSystem$$fileMatchesPattern(this.$outer, A1, this.pattern$1, this.verbose$1) ? A1.getPath() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(File x1) {
                File file = x1;
                boolean bl = FileSystem$class.org$specs2$io$FileSystem$$fileMatchesPattern(this.$outer, file, this.pattern$1, this.verbose$1);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pattern$1 = pattern$1;
                this.verbose$1 = verbose$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSeq();
    }

    public static boolean org$specs2$io$FileSystem$$isVersionFile(FileSystem $this, File f) {
        return ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".svn", ".cvs"}))).exists((Function1)new Serializable($this, f){
            private final File f$1;

            public final boolean apply(String x$1) {
                return this.f$1.getPath().contains(x$1);
            }
            {
                this.f$1 = f$1;
            }
        });
    }

    public static boolean org$specs2$io$FileSystem$$fileMatchesPattern(FileSystem $this, File f, String pattern, boolean verbose) {
        String filePath = Paths$.MODULE$.toPath(f.getPath().replaceFirst(".:", "")).unixize();
        if (verbose) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)filePath).append((Object)" matches pattern: ").append((Object)BoxesRunTime.boxToBoolean((boolean)filePath.matches(pattern))).toString());
        }
        return filePath.matches(pattern);
    }

    private static boolean fileMatchesPattern$default$3(FileSystem $this) {
        return false;
    }

    public static Stream org$specs2$io$FileSystem$$recurse(FileSystem $this, File file) {
        return Stream.cons$.MODULE$.apply((Object)file, (Function0)new Serializable($this, file){
            private final /* synthetic */ FileSystem $outer;
            private final File file$1;

            public final Stream<File> apply() {
                return this.file$1.listFiles() == null ? package$.MODULE$.Stream().empty() : (Stream)((Stream)Predef$.MODULE$.refArrayOps((Object[])this.file$1.listFiles()).toStream().filterNot((Function1)new Serializable(this){
                    private final /* synthetic */ FileSystem$$anonfun$org$specs2$io$FileSystem$.recurse.1 $outer;

                    public final boolean apply(File f) {
                        return FileSystem$class.org$specs2$io$FileSystem$$isVersionFile(this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer(), f);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).flatMap((Function1)new Serializable(this){
                    private final /* synthetic */ FileSystem$$anonfun$org$specs2$io$FileSystem$.recurse.1 $outer;

                    public final Stream<File> apply(File file) {
                        return FileSystem$class.org$specs2$io$FileSystem$$recurse(this.$outer.org$specs2$io$FileSystem$$anonfun$$$outer(), file);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, package$.MODULE$.Stream().canBuildFrom());
            }

            public /* synthetic */ FileSystem org$specs2$io$FileSystem$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.file$1 = file$1;
            }
        }).filter((Function1)new Serializable($this){

            public final boolean apply(File x$2) {
                return x$2.isFile();
            }
        });
    }

    public static String globToPattern(FileSystem $this, String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = new StringBuilder().append((Object)"[^\\/\\?<>\\|\\").append((Object)star).append((Object)":\"]").append((Object)star).toString();
        return glob.replace("\\", "/").replace(".", "\\.").replace("**/", new StringBuilder().append((Object)"(").append((Object)authorizedNamePattern).append((Object)"/)").append((Object)star).toString()).replace("*", authorizedNamePattern).replace(star, "*");
    }

    public static boolean isDir(FileSystem $this, String path) {
        return $this.isDirectory(path);
    }

    public static boolean createDir(FileSystem $this, String path) {
        return new File(path).mkdirs();
    }

    public static String removeDir(FileSystem $this, String path) {
        Object object;
        File dir = new File(path);
        if (dir.isDirectory()) {
            boolean bl;
            if (dir.listFiles() == null || Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).isEmpty()) {
                bl = dir.delete();
            } else {
                Predef$.MODULE$.refArrayOps((Object[])dir.listFiles()).foreach((Function1)new Serializable($this){
                    private final /* synthetic */ FileSystem $outer;

                    public final Object apply(File file) {
                        return file.isFile() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : this.$outer.removeDir(file.getPath());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                bl = dir.delete();
            }
            object = BoxesRunTime.boxToBoolean((boolean)bl);
        } else {
            object = BoxedUnit.UNIT;
        }
        return dir.getParent();
    }

    public static boolean canRead(FileSystem $this, String path) {
        return path != null && new File(path).canRead();
    }

    public static boolean canWrite(FileSystem $this, String path) {
        return path != null && new File(path).canWrite();
    }

    public static boolean isAbsolute(FileSystem $this, String path) {
        return path != null && new File(path).isAbsolute();
    }

    public static boolean isFile(FileSystem $this, String path) {
        return path != null && new File(path).isFile();
    }

    public static boolean isDirectory(FileSystem $this, String path) {
        return path != null && new File(path).isDirectory();
    }

    public static boolean isHidden(FileSystem $this, String path) {
        return path != null && new File(path).isHidden();
    }

    public static String getName(FileSystem $this, String path) {
        return new File(path).getName();
    }

    public static String getAbsolutePath(FileSystem $this, String path) {
        return new File(path).getAbsolutePath();
    }

    public static String getCanonicalPath(FileSystem $this, String path) {
        return new File(path).getCanonicalPath();
    }

    public static String getParent(FileSystem $this, String path) {
        return new File(path).getParent();
    }

    public static List listFiles(FileSystem $this, String path) {
        return new File(path).list() == null ? Nil$.MODULE$ : Predef$.MODULE$.refArrayOps((Object[])new File(path).list()).toList();
    }

    public static void copyDir(FileSystem $this, String src, String dest) {
        ((List)$this.listFiles(src).filterNot((Function1)new Serializable($this){

            public final boolean apply(String x$3) {
                return x$3.contains(".svn");
            }
        })).foreach((Function1)new Serializable($this, src, dest){
            private final /* synthetic */ FileSystem $outer;
            private final String src$1;
            private final String dest$1;

            public final void apply(String name) {
                String path = new StringBuilder().append((Object)this.src$1).append((Object)"/").append((Object)name).toString();
                if (new File(path).isDirectory()) {
                    this.$outer.copyDir(path, this.dest$1);
                } else {
                    this.$outer.copyFile(path, this.dest$1);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.src$1 = src$1;
                this.dest$1 = dest$1;
            }
        });
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static void copyFile(FileSystem $this, String path, String dest) {
        $this.mkdirs(dest);
        String destFilePath = new StringBuilder().append((Object)dest).append((Object)"/").append((Object)new File(path).getName()).toString();
        new File(destFilePath).createNewFile();
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(destFilePath), 2048);
        $this.copy(input, output);
        output.flush();
        output.close();
        input.close();
        return;
        {
            catch (Throwable throwable) {
                try {
                    void var6_5;
                    var6_5.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    void var4_4;
                    var4_4.close();
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void org$specs2$io$FileSystem$$unjar(FileSystem $this, URL jarUrl, String dirPath, String regexFilter) {
        $this.mkdirs(dirPath);
        Pattern regex = Pattern.compile(regexFilter);
        InputStream uis = jarUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(uis));
        try {
            FileSystem$class.extractEntry$1($this, zis.getNextEntry(), dirPath, regex, zis);
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        zis.close();
    }

    public static void copy(FileSystem $this, InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        FileSystem$class.readData$1($this, input.read(data, 0, 2048), data, input, output);
    }

    public static void copySpecResourcesDir(FileSystem $this, String base, String src, String outputDir, ClassLoader loader) {
        Option$.MODULE$.apply((Object)loader.getResource(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{base, src})))).foreach((Function1)new Serializable($this, base, src, outputDir){
            private final /* synthetic */ FileSystem $outer;
            private final String base$1;
            private final String src$2;
            private final String outputDir$1;

            public final void apply(URL url) {
                if (url.getProtocol().equalsIgnoreCase("jar")) {
                    FileSystem$class.org$specs2$io$FileSystem$$unjar(this.$outer, FileSystem$class.org$specs2$io$FileSystem$$jarOf(this.$outer, url), this.outputDir$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"^", "(/", "/.*)$"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Pattern.quote(this.base$1), Pattern.quote(this.src$2)})));
                } else {
                    this.$outer.copyDir(url.getPath(), new File(this.outputDir$1, this.src$2).getPath());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.base$1 = base$1;
                this.src$2 = src$2;
                this.outputDir$1 = outputDir$1;
            }
        });
    }

    public static URL org$specs2$io$FileSystem$$jarOf(FileSystem $this, URL url) {
        return ((JarURLConnection)url.openConnection()).getJarFileURL();
    }

    public static boolean samePath(FileSystem $this, String p1, String p2) {
        String string = new File(p1).getCanonicalPath();
        String string2 = new File(p2).getCanonicalPath();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final void extractEntry$1(FileSystem $this, ZipEntry entry, String dirPath$1, Pattern regex$1, ZipInputStream zis$1) {
        while (true) {
            block7: {
                Object object;
                block6: {
                    if (entry == null) {
                        return;
                    }
                    Matcher matcher = regex$1.matcher(entry.getName());
                    if (!matcher.matches()) break block6;
                    String target = matcher.replaceFirst(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "$1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Matcher.quoteReplacement(dirPath$1)})));
                    if (entry.isDirectory()) {
                        object = BoxesRunTime.boxToBoolean((boolean)$this.createDir(target));
                        break block7;
                    } else {
                        $this.createFile(target);
                        FileOutputStream fos = new FileOutputStream(target);
                        BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                        try {
                            $this.copy(zis$1, dest);
                            dest.flush();
                        }
                        catch (Throwable throwable) {
                            void var9_8;
                            var9_8.close();
                            throw throwable;
                        }
                        dest.close();
                        object = BoxedUnit.UNIT;
                    }
                    break block7;
                }
                object = BoxedUnit.UNIT;
            }
            entry = zis$1.getNextEntry();
        }
    }

    private static final void readData$1(FileSystem $this, int count, byte[] data$1, InputStream input$1, OutputStream output$1) {
        while (count != -1) {
            output$1.write(data$1, 0, count);
            output$1.flush();
            count = input$1.read(data$1, 0, 2048);
        }
    }

    public static void $init$(FileSystem $this) {
    }
}

