/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.storage.listedlicense;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.DuplicateSpdxIdException;
import org.spdx.library.model.SpdxIdNotFoundException;
import org.spdx.library.model.TypedValue;
import org.spdx.library.model.license.LicenseInfoFactory;
import org.spdx.library.model.license.SpdxListedLicenseException;
import org.spdx.storage.IModelStore;
import org.spdx.storage.listedlicense.CrossRefJson;
import org.spdx.storage.listedlicense.ExceptionJson;
import org.spdx.storage.listedlicense.ExceptionJsonTOC;
import org.spdx.storage.listedlicense.IListedLicenseStore;
import org.spdx.storage.listedlicense.LicenseJson;
import org.spdx.storage.listedlicense.LicenseJsonTOC;

public abstract class SpdxListedLicenseModelStore
implements IListedLicenseStore {
    static final Logger logger = LoggerFactory.getLogger((String)SpdxListedLicenseModelStore.class.getName());
    static final String DEFAULT_LICENSE_LIST_VERSION = "3.17";
    static final String LICENSE_TOC_FILENAME = "licenses.json";
    static final String EXCEPTION_TOC_FILENAME = "exceptions.json";
    static final String JSON_SUFFIX = ".json";
    private static final List<String> DOCUMENT_URIS = Collections.unmodifiableList(Arrays.asList("https://spdx.org/licenses/"));
    private static final String ANONYMOUS_ID_PREFIX = "SpdxLicenseGeneratedId-";
    Map<String, String> licenseIds = new HashMap<String, String>();
    Map<String, String> exceptionIds = new HashMap<String, String>();
    Map<String, LicenseJson> listedLicenseCache = null;
    Map<String, ExceptionJson> listedExceptionCache = null;
    Map<String, CrossRefJson> crossRefs = new HashMap<String, CrossRefJson>();
    String licenseListVersion = "3.17";
    private int nextId = 0;
    private final ReadWriteLock listedLicenseModificationLock = new ReentrantReadWriteLock();
    private final IModelStore.IModelStoreLock readLock = new IModelStore.IModelStoreLock(){

        @Override
        public void unlock() {
            SpdxListedLicenseModelStore.this.listedLicenseModificationLock.readLock().unlock();
        }
    };
    private final IModelStore.IModelStoreLock writeLock = new IModelStore.IModelStoreLock(){

        @Override
        public void unlock() {
            SpdxListedLicenseModelStore.this.listedLicenseModificationLock.writeLock().unlock();
        }
    };
    Gson gson = new Gson();

    public SpdxListedLicenseModelStore() throws InvalidSPDXAnalysisException {
        this.loadIds();
    }

    public abstract InputStream getTocInputStream() throws IOException;

    public abstract InputStream getExceptionTocInputStream() throws IOException;

    public abstract InputStream getLicenseInputStream(String var1) throws IOException;

    public abstract InputStream getExceptionInputStream(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIds() throws InvalidSPDXAnalysisException {
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            this.listedLicenseCache = new HashMap<String, LicenseJson>();
            this.listedExceptionCache = new HashMap<String, ExceptionJson>();
            this.licenseIds = new HashMap<String, String>();
            InputStream tocStream = null;
            BufferedReader reader = null;
            try {
                String line;
                tocStream = this.getTocInputStream();
                reader = new BufferedReader(new InputStreamReader(tocStream, "UTF-8"));
                StringBuilder tocJsonStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    tocJsonStr.append(line);
                }
                LicenseJsonTOC jsonToc = (LicenseJsonTOC)this.gson.fromJson(tocJsonStr.toString(), LicenseJsonTOC.class);
                this.licenseIds = jsonToc.getLicenseIds();
                this.licenseListVersion = jsonToc.getLicenseListVersion();
                tocStream = this.getExceptionTocInputStream();
                reader = new BufferedReader(new InputStreamReader(tocStream, "UTF-8"));
                tocJsonStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    tocJsonStr.append(line);
                }
                ExceptionJsonTOC exceptionToc = (ExceptionJsonTOC)this.gson.fromJson(tocJsonStr.toString(), ExceptionJsonTOC.class);
                this.exceptionIds = exceptionToc.getExceptionIds();
            }
            catch (MalformedURLException e) {
                throw new SpdxListedLicenseException("License TOC URL invalid", e);
            }
            catch (IOException e) {
                throw new SpdxListedLicenseException("I/O error reading license TOC", e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        logger.warn("Unable to close JSON TOC reader", (Throwable)e);
                    }
                }
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String documentUri, String id) {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            return false;
        }
        this.listedLicenseModificationLock.readLock().lock();
        try {
            boolean bl = this.licenseIds.containsKey(id.toLowerCase()) || this.exceptionIds.containsKey(id.toLowerCase()) || this.crossRefs.containsKey(id);
            return bl;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(String documentUri, String id, String type) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if ("CrossRef".equals(type)) {
                CrossRefJson crossRef = new CrossRefJson();
                crossRef.setId(id);
                this.crossRefs.put(id, crossRef);
            } else if ("ListedLicense".equals(type)) {
                if (this.licenseIds.containsKey(id.toLowerCase()) || this.exceptionIds.containsKey(id.toLowerCase())) {
                    logger.error("Duplicate SPDX ID on create: " + id);
                    throw new DuplicateSpdxIdException("ID " + id + " already exists.");
                }
                this.licenseIds.put(id.toLowerCase(), id);
                this.listedLicenseCache.put(id, new LicenseJson(id));
            } else if ("ListedLicenseException".equals(type)) {
                if (this.licenseIds.containsKey(id.toLowerCase()) || this.exceptionIds.containsKey(id.toLowerCase())) {
                    logger.error("Duplicate SPDX ID on create: " + id);
                    throw new DuplicateSpdxIdException("ID " + id + " already exists.");
                }
                this.exceptionIds.put(id.toLowerCase(), id);
                this.listedExceptionCache.put(id, new ExceptionJson(id));
            }
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    @Override
    public List<String> getPropertyValueNames(String documentUri, String id) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
            if (isLicenseId) {
                LicenseJson license = this.fetchLicenseJson(this.licenseIds.get(id.toLowerCase()));
                List<String> list = license.getPropertyValueNames();
                return list;
            }
            if (isExceptionId) {
                ExceptionJson exc = this.fetchExceptionJson(this.exceptionIds.get(id.toLowerCase()));
                List<String> list = exc.getPropertyValueNames();
                return list;
            }
            if (Objects.nonNull(crossRef)) {
                List<String> list = crossRef.getPropertyValueNames();
                return list;
            }
            logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID. crossRef ID nor a listed exception ID");
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LicenseJson fetchLicenseJson(String idCaseInsensitive) throws InvalidSPDXAnalysisException {
        String idLowerCase = idCaseInsensitive.toLowerCase();
        String id = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            id = this.licenseIds.get(idLowerCase);
            if (Objects.isNull(id)) {
                logger.error("Attemting to get property values on non-existent ID " + idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (this.listedLicenseCache.containsKey(id)) {
                LicenseJson licenseJson = this.listedLicenseCache.get(id);
                return licenseJson;
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            id = this.licenseIds.get(idLowerCase);
            if (Objects.isNull(id)) {
                logger.error("Attemting to get property values on non-existent ID " + idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (!this.listedLicenseCache.containsKey(id)) {
                InputStream jsonStream = null;
                BufferedReader reader = null;
                try {
                    String line;
                    jsonStream = this.getLicenseInputStream(id);
                    reader = new BufferedReader(new InputStreamReader(jsonStream, "UTF-8"));
                    StringBuilder licenseJsonStr = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        licenseJsonStr.append(line);
                    }
                    LicenseJson license = (LicenseJson)this.gson.fromJson(licenseJsonStr.toString(), LicenseJson.class);
                    this.listedLicenseCache.put(id, license);
                }
                catch (MalformedURLException e) {
                    logger.error("Json license invalid for ID " + id, (Throwable)e);
                    throw new SpdxListedLicenseException("JSON license URL invalid for ID " + id, e);
                }
                catch (IOException e) {
                    logger.error("I/O error opening Json license URL", (Throwable)e);
                    throw new SpdxListedLicenseException("I/O Error reading license data for ID " + id, e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC reader", (Throwable)e);
                        }
                    } else if (jsonStream != null) {
                        try {
                            jsonStream.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC input stream", (Throwable)e);
                        }
                    }
                }
            }
            LicenseJson licenseJson = this.listedLicenseCache.get(id);
            return licenseJson;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExceptionJson fetchExceptionJson(String idCaseInsensitive) throws InvalidSPDXAnalysisException {
        String idLower = idCaseInsensitive.toLowerCase();
        String id = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            id = this.exceptionIds.get(idLower);
            if (Objects.isNull(id)) {
                logger.error("Attemting to get property values on non-existent ID " + idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (this.listedExceptionCache.containsKey(id)) {
                ExceptionJson exceptionJson = this.listedExceptionCache.get(id);
                return exceptionJson;
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            id = this.exceptionIds.get(idLower);
            if (Objects.isNull(id)) {
                logger.error("Attemting to get property values on non-existent ID " + idCaseInsensitive);
                throw new SpdxIdNotFoundException("ID " + idCaseInsensitive + " not found.");
            }
            if (!this.listedExceptionCache.containsKey(id)) {
                InputStream jsonStream = null;
                BufferedReader reader = null;
                try {
                    String line;
                    jsonStream = this.getExceptionInputStream(id);
                    reader = new BufferedReader(new InputStreamReader(jsonStream, "UTF-8"));
                    StringBuilder exceptionJsonStr = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        exceptionJsonStr.append(line);
                    }
                    ExceptionJson exc = (ExceptionJson)this.gson.fromJson(exceptionJsonStr.toString(), ExceptionJson.class);
                    this.listedExceptionCache.put(id, exc);
                }
                catch (MalformedURLException e) {
                    logger.error("Json license invalid for ID " + id);
                    throw new SpdxListedLicenseException("JSON license URL invalid for ID " + id, e);
                }
                catch (IOException e) {
                    logger.error("I/O error opening Json license URL");
                    throw new SpdxListedLicenseException("I/O Error reading license data for ID " + id, e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC reader", (Throwable)e);
                        }
                    } else if (jsonStream != null) {
                        try {
                            jsonStream.close();
                        }
                        catch (IOException e) {
                            logger.warn("Unable to close JSON TOC input stream", (Throwable)e);
                        }
                    }
                }
            }
            ExceptionJson exceptionJson = this.listedExceptionCache.get(id);
            return exceptionJson;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            license.setPrimativeValue(propertyName, value);
        } else if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            exc.setPrimativeValue(propertyName, value);
        } else if (Objects.nonNull(crossRef)) {
            crossRef.setPrimativeValue(propertyName, value);
        } else {
            logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearValueCollection(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            license.clearPropertyValueList(propertyName);
        } else if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            exc.clearPropertyValueList(propertyName);
        } else if (Objects.nonNull(crossRef)) {
            crossRef.clearPropertyValueList(propertyName);
        } else {
            logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addValueToCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            if ("crossRef".equals(propertyName)) {
                if (!(value instanceof TypedValue)) {
                    logger.error("Invalid class for CrossRef - expected TypedValue, was supplied type " + value.getClass().toString());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expected TypedValue, was supplied type " + value.getClass().toString());
                }
                TypedValue tv = (TypedValue)value;
                if (!"CrossRef".equals(tv.getType())) {
                    logger.error("Invalid type for CrossRef - expectedCrossRef, was supplied type " + value.getClass().toString());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expectedCrossRef, was supplied type " + value.getClass().toString());
                }
                CrossRefJson crj = this.crossRefs.get(tv.getId());
                if (Objects.isNull(crj)) {
                    logger.error("CrossRef with ID " + tv.getId() + " does not exist in the store.");
                    throw new InvalidSPDXAnalysisException("CrossRef with ID " + tv.getId() + " does not exist in the store.");
                }
                return license.addCrossRefValueToList(propertyName, crj);
            }
            return license.addPrimitiveValueToList(propertyName, value);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.addPrimitiveValueToList(propertyName, value);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.addPrimitiveValueToList(propertyName, value);
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeValueFromCollection(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            if ("crossRef".equals(propertyName)) {
                if (!(value instanceof TypedValue)) {
                    logger.error("Invalid class for CrossRef - expected TypedValue, was supplied type " + value.getClass().toString());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expected TypedValue, was supplied type " + value.getClass().toString());
                }
                TypedValue tv = (TypedValue)value;
                if (!"CrossRef".equals(tv.getType())) {
                    logger.error("Invalid type for CrossRef - expectedCrossRef, was supplied type " + value.getClass().toString());
                    throw new InvalidSPDXAnalysisException("Invalid type for CrossRef - expectedCrossRef, was supplied type " + value.getClass().toString());
                }
                CrossRefJson crj = this.crossRefs.get(tv.getId());
                if (Objects.isNull(crj)) {
                    logger.error("CrossRef with ID " + tv.getId() + " does not exist in the store.");
                    throw new InvalidSPDXAnalysisException("CrossRef with ID " + tv.getId() + " does not exist in the store.");
                }
                return license.removePrimitiveValueToList(propertyName, crj);
            }
            return license.removePrimitiveValueToList(propertyName, value);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.removePrimitiveValueToList(propertyName, value);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.removePrimitiveValueToList(propertyName, value);
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Object> listValues(String documentUri, String id, final String propertyName) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            List<?> valueList = license.getValueList(propertyName);
            if ("crossRef".equals(propertyName)) {
                final Iterator<?> crossRefJsonIter = valueList.iterator();
                return new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return crossRefJsonIter.hasNext();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object next() {
                        String crossRefId;
                        block9: {
                            Object nextVal = crossRefJsonIter.next();
                            if (Objects.isNull(nextVal)) {
                                return null;
                            }
                            if (!(nextVal instanceof CrossRefJson)) {
                                throw new RuntimeException(new InvalidSPDXAnalysisException("Invalid type for " + propertyName + ".  Must be of type CrossRefJson"));
                            }
                            CrossRefJson nextCrossRef = (CrossRefJson)nextVal;
                            crossRefId = nextCrossRef.getId();
                            SpdxListedLicenseModelStore.this.listedLicenseModificationLock.writeLock().lock();
                            try {
                                if (!Objects.isNull(crossRefId)) break block9;
                                try {
                                    crossRefId = SpdxListedLicenseModelStore.this.getNextId(IModelStore.IdType.Anonymous, "https://spdx.org/licenses/");
                                }
                                catch (InvalidSPDXAnalysisException e) {
                                    logger.error("Error getting next Anonymous ID", (Throwable)e);
                                    throw new RuntimeException(e);
                                }
                                nextCrossRef.setId(crossRefId);
                                SpdxListedLicenseModelStore.this.crossRefs.put(crossRefId, nextCrossRef);
                            }
                            finally {
                                SpdxListedLicenseModelStore.this.listedLicenseModificationLock.writeLock().unlock();
                            }
                        }
                        try {
                            return new TypedValue(crossRefId, "CrossRef");
                        }
                        catch (InvalidSPDXAnalysisException e) {
                            logger.error("Error creating TypedValue for CrossRef", (Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
            return valueList.iterator();
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.getValueList(propertyName).iterator();
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.getValueList(propertyName).iterator();
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<Object> getValue(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return Optional.ofNullable(license.getValue(propertyName));
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return Optional.ofNullable(exc.getValue(propertyName));
        }
        if (Objects.nonNull(crossRef)) {
            return Optional.ofNullable(crossRef.getValue(propertyName));
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNextId(IModelStore.IdType idType, String documentUri) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        this.listedLicenseModificationLock.writeLock().lock();
        try {
            if (IModelStore.IdType.Anonymous.equals((Object)idType)) {
                String string = ANONYMOUS_ID_PREFIX + String.valueOf(this.nextId++);
                return string;
            }
            String string = "listedLicenseId_" + String.valueOf(this.nextId++);
            return string;
        }
        finally {
            this.listedLicenseModificationLock.writeLock().unlock();
        }
    }

    @Override
    public List<String> getSpdxListedLicenseIds() {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            ArrayList<String> retval = new ArrayList<String>();
            retval.addAll(this.licenseIds.values());
            ArrayList<String> arrayList = retval;
            return arrayList;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    @Override
    public String getLicenseListVersion() {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            String string = this.licenseListVersion;
            return string;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    @Override
    public List<String> getSpdxListedExceptionIds() {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            ArrayList<String> retval = new ArrayList<String>();
            retval.addAll(this.exceptionIds.values());
            ArrayList<String> arrayList = retval;
            return arrayList;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSpdxListedLicenseId(String listedLicenseDocumentUri, String licenseId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            boolean bl = this.licenseIds.containsKey(licenseId.toLowerCase());
            return bl;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSpdxListedExceptionId(String listedLicenseDocumentUri, String exceptionId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            boolean bl = this.exceptionIds.containsKey(exceptionId.toLowerCase());
            return bl;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<TypedValue> getTypedValue(String documentUri, String id) throws InvalidSPDXAnalysisException {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                Optional<TypedValue> optional = Optional.of(new TypedValue(id, "ListedLicense"));
                return optional;
            }
            if (this.exceptionIds.containsKey(id.toLowerCase())) {
                Optional<TypedValue> optional = Optional.of(new TypedValue(id, "ListedLicenseException"));
                return optional;
            }
            if (this.crossRefs.containsKey(id)) {
                Optional<TypedValue> optional = Optional.of(new TypedValue(id, "CrossRef"));
                return optional;
            }
            Optional<TypedValue> optional = Optional.empty();
            return optional;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            license.removeProperty(propertyName);
        } else if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            exc.removeProperty(propertyName);
        } else if (Objects.nonNull(crossRef)) {
            crossRef.removeProperty(propertyName);
        } else {
            logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
            throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        }
    }

    @Override
    public List<String> getDocumentUris() {
        return DOCUMENT_URIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<TypedValue> getAllItems(String documentUri, @Nullable String typeFilter) throws InvalidSPDXAnalysisException {
        Objects.requireNonNull(typeFilter, "Type filter can not be null");
        this.listedLicenseModificationLock.readLock().lock();
        try {
            ArrayList<TypedValue> allItems = new ArrayList<TypedValue>();
            if (Objects.isNull(typeFilter) || "ListedLicense".equals(typeFilter)) {
                for (String licenseId : this.licenseIds.values()) {
                    allItems.add(new TypedValue(licenseId, "ListedLicense"));
                }
            }
            if (Objects.isNull(typeFilter) || "ListedLicenseException".equals(typeFilter)) {
                for (String exceptionId : this.exceptionIds.values()) {
                    allItems.add(new TypedValue(exceptionId, "ListedLicenseException"));
                }
            }
            if (Objects.isNull(typeFilter) || "CrossRef".equals(typeFilter)) {
                for (String crossRefId : this.crossRefs.keySet()) {
                    allItems.add(new TypedValue(crossRefId, "CrossRef"));
                }
            }
            Stream stream = Collections.unmodifiableList(allItems).stream();
            return stream;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int collectionSize(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return license.getValueList(propertyName).size();
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.getValueList(propertyName).size();
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.getValueList(propertyName).size();
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean collectionContains(String documentUri, String id, String propertyName, Object value) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            List<?> valueList = license.getValueList(propertyName);
            if (value instanceof TypedValue && "CrossRef".equals(((TypedValue)value).getType())) {
                CrossRefJson compareValue = this.crossRefs.get(((TypedValue)value).getId());
                if (Objects.isNull(compareValue)) {
                    return false;
                }
                return valueList.contains(compareValue);
            }
            return valueList.contains(value);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.getValueList(propertyName).contains(value);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.getValueList(propertyName).contains(value);
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCollectionMembersAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return license.isCollectionMembersAssignableTo(propertyName, clazz);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.isCollectionMembersAssignableTo(propertyName, clazz);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.isCollectionMembersAssignableTo(propertyName, clazz);
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPropertyValueAssignableTo(String documentUri, String id, String propertyName, Class<?> clazz) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return license.isPropertyValueAssignableTo(propertyName, clazz);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.isPropertyValueAssignableTo(propertyName, clazz);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.isPropertyValueAssignableTo(propertyName, clazz);
        }
        logger.error("ID " + id + " is not a listed license ID, CrossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, CrossRef ID nor a listed exception ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCollectionProperty(String documentUri, String id, String propertyName) throws InvalidSPDXAnalysisException {
        if (!"https://spdx.org/licenses/".equals(documentUri)) {
            logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
        }
        boolean isLicenseId = false;
        boolean isExceptionId = false;
        CrossRefJson crossRef = null;
        this.listedLicenseModificationLock.readLock().lock();
        try {
            if (this.licenseIds.containsKey(id.toLowerCase())) {
                isLicenseId = true;
            } else if (this.exceptionIds.containsKey(id.toLowerCase())) {
                isExceptionId = true;
            } else if (this.crossRefs.containsKey(id)) {
                crossRef = this.crossRefs.get(id);
            }
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
        if (isLicenseId) {
            LicenseJson license = this.fetchLicenseJson(id);
            return license.isCollectionProperty(propertyName);
        }
        if (isExceptionId) {
            ExceptionJson exc = this.fetchExceptionJson(id);
            return exc.isCollectionProperty(propertyName);
        }
        if (Objects.nonNull(crossRef)) {
            return crossRef.isCollectionProperty(propertyName);
        }
        logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
        throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
    }

    @Override
    public IModelStore.IdType getIdType(String id) {
        Objects.requireNonNull(id, "ID must not be null");
        if (LicenseInfoFactory.isSpdxListedLicenseId(id) || LicenseInfoFactory.isSpdxListedExceptionId(id)) {
            return IModelStore.IdType.ListedLicense;
        }
        if (id.startsWith(ANONYMOUS_ID_PREFIX)) {
            return IModelStore.IdType.Anonymous;
        }
        return IModelStore.IdType.Unkown;
    }

    @Override
    public IModelStore.IModelStoreLock enterCriticalSection(String documentUri, boolean readLockRequested) {
        if (readLockRequested) {
            this.listedLicenseModificationLock.readLock().lock();
            return this.readLock;
        }
        this.listedLicenseModificationLock.writeLock().lock();
        return this.writeLock;
    }

    @Override
    public void leaveCriticalSection(IModelStore.IModelStoreLock lock) {
        lock.unlock();
    }

    @Override
    public Optional<String> listedLicenseIdCaseSensitive(String licenseId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.licenseIds.get(licenseId.toLowerCase()));
            return optional;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    @Override
    public Optional<String> listedExceptionIdCaseSensitive(String exceptionId) {
        this.listedLicenseModificationLock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.exceptionIds.get(exceptionId.toLowerCase()));
            return optional;
        }
        finally {
            this.listedLicenseModificationLock.readLock().unlock();
        }
    }

    @Override
    public Optional<String> getCaseSensisitiveId(String documentUri, String caseInsensisitiveId) {
        Optional<String> retval = this.listedLicenseIdCaseSensitive(caseInsensisitiveId);
        if (retval.isPresent()) {
            return retval;
        }
        return this.listedExceptionIdCaseSensitive(caseInsensisitiveId);
    }

    @Override
    public void delete(String documentUri, String id) throws InvalidSPDXAnalysisException {
        block7: {
            if (!"https://spdx.org/licenses/".equals(documentUri)) {
                logger.error("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
                throw new SpdxIdNotFoundException("Document URI for SPDX listed licenses is expected to be https://spdx.org/licenses/.  Supplied document URI was " + documentUri);
            }
            this.listedLicenseModificationLock.writeLock().lock();
            try {
                if (this.licenseIds.containsKey(id.toLowerCase())) {
                    this.listedLicenseCache.remove(id);
                    this.licenseIds.remove(id.toLowerCase());
                    break block7;
                }
                if (this.exceptionIds.containsKey(id.toLowerCase())) {
                    this.listedExceptionCache.remove(id);
                    this.exceptionIds.remove(id.toLowerCase());
                    break block7;
                }
                if (this.crossRefs.containsKey(id)) {
                    this.crossRefs.remove(id);
                    break block7;
                }
                logger.error("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
                throw new SpdxIdNotFoundException("ID " + id + " is not a listed license ID, crossRef ID nor a listed exception ID");
            }
            finally {
                this.listedLicenseModificationLock.writeLock().unlock();
            }
        }
    }
}

