/*
 * Decompiled with CFR 0.152.
 */
package org.spdx.library.model.license;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spdx.Configuration;
import org.spdx.library.InvalidSPDXAnalysisException;
import org.spdx.library.model.SpdxModelFactory;
import org.spdx.library.model.license.ListedLicenseException;
import org.spdx.library.model.license.SpdxListedLicense;
import org.spdx.storage.IModelStore;
import org.spdx.storage.listedlicense.IListedLicenseStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseLocalStore;
import org.spdx.storage.listedlicense.SpdxListedLicenseWebStore;

public class ListedLicenses {
    static final Logger logger = LoggerFactory.getLogger((String)ListedLicenses.class.getName());
    boolean onlyUseLocalLicenses;
    private IListedLicenseStore licenseModelStore;
    private static ListedLicenses listedLicenses = null;
    private static final ReadWriteLock listedLicenseModificationLock = new ReentrantReadWriteLock();

    private ListedLicenses() {
        this.onlyUseLocalLicenses = Boolean.parseBoolean(Configuration.getInstance().getProperty("org.spdx.useJARLicenseInfoOnly", Configuration.getInstance().getProperty("SPDXParser.OnlyUseLocalLicenses", Configuration.getInstance().getProperty("OnlyUseLocalLicenses", "false"))));
        this.initializeLicenseModelStore();
    }

    private ListedLicenses(IListedLicenseStore licenseModelStore) {
        this.licenseModelStore = licenseModelStore;
    }

    private void initializeLicenseModelStore() {
        block8: {
            listedLicenseModificationLock.writeLock().lock();
            try {
                if (!this.onlyUseLocalLicenses) {
                    try {
                        this.licenseModelStore = new SpdxListedLicenseWebStore();
                    }
                    catch (InvalidSPDXAnalysisException ex) {
                        logger.error("Unable to access the most current listed licenses from https://spdx.org/licenses - using locally cached licenses: " + ex.getMessage(), (Throwable)ex);
                        this.licenseModelStore = null;
                    }
                }
                if (this.licenseModelStore != null) break block8;
                try {
                    this.licenseModelStore = new SpdxListedLicenseLocalStore();
                }
                catch (InvalidSPDXAnalysisException ex) {
                    logger.error("Error loading cached SPDX licenses", (Throwable)ex);
                    throw new RuntimeException("Unexpected error loading SPDX Listed Licenses", ex);
                }
            }
            finally {
                listedLicenseModificationLock.writeLock().unlock();
            }
        }
    }

    public static ListedLicenses getListedLicenses() {
        ListedLicenses retval = null;
        listedLicenseModificationLock.readLock().lock();
        try {
            retval = listedLicenses;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
        if (Objects.isNull(retval)) {
            listedLicenseModificationLock.writeLock().lock();
            try {
                if (listedLicenses == null) {
                    listedLicenses = new ListedLicenses();
                }
                retval = listedLicenses;
            }
            finally {
                listedLicenseModificationLock.writeLock().unlock();
            }
        }
        return retval;
    }

    public static ListedLicenses initializeListedLicenses(IListedLicenseStore licenseStore) {
        listedLicenseModificationLock.writeLock().lock();
        try {
            ListedLicenses listedLicenses = ListedLicenses.listedLicenses = new ListedLicenses(licenseStore);
            return listedLicenses;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public static ListedLicenses resetListedLicenses() {
        listedLicenseModificationLock.writeLock().lock();
        try {
            ListedLicenses listedLicenses = ListedLicenses.listedLicenses = new ListedLicenses();
            return listedLicenses;
        }
        finally {
            listedLicenseModificationLock.writeLock().unlock();
        }
    }

    public boolean isSpdxListedLicenseId(String licenseId) {
        return this.licenseModelStore.isSpdxListedLicenseId("https://spdx.org/licenses/", licenseId);
    }

    public boolean isSpdxListedExceptionId(String exceptionId) {
        return this.licenseModelStore.isSpdxListedExceptionId("https://spdx.org/licenses/", exceptionId);
    }

    public SpdxListedLicense getListedLicenseById(String licenseId) throws InvalidSPDXAnalysisException {
        return (SpdxListedLicense)SpdxModelFactory.createModelObject(this.licenseModelStore, "https://spdx.org/licenses/", licenseId, "ListedLicense", null);
    }

    public ListedLicenseException getListedExceptionById(String exceptionId) throws InvalidSPDXAnalysisException {
        return (ListedLicenseException)SpdxModelFactory.createModelObject(this.licenseModelStore, "https://spdx.org/licenses/", exceptionId, "ListedLicenseException", null);
    }

    public List<String> getSpdxListedLicenseIds() {
        listedLicenseModificationLock.readLock().lock();
        try {
            List<String> list = this.licenseModelStore.getSpdxListedLicenseIds();
            return list;
        }
        finally {
            listedLicenseModificationLock.readLock().unlock();
        }
    }

    public String getLicenseListVersion() {
        return this.licenseModelStore.getLicenseListVersion();
    }

    public List<String> getSpdxListedExceptionIds() {
        return this.licenseModelStore.getSpdxListedExceptionIds();
    }

    public Optional<String> listedLicenseIdCaseSensitive(String licenseId) {
        return this.licenseModelStore.listedLicenseIdCaseSensitive(licenseId);
    }

    public Optional<String> listedExceptionIdCaseSensitive(String exceptionId) {
        return this.licenseModelStore.listedExceptionIdCaseSensitive(exceptionId);
    }

    public IModelStore getLicenseModelStore() {
        return this.licenseModelStore;
    }
}

