/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.rules;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;
import org.sonar.api.profiles.ProfileDefinition;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.ValidationMessages;

public final class XmlSonarWayProfile
extends ProfileDefinition {
    private final RuleFinder ruleFinder;

    public XmlSonarWayProfile(RuleFinder ruleFinder) {
        this.ruleFinder = ruleFinder;
    }

    public RulesProfile createProfile(ValidationMessages validation) {
        RulesProfile profile = RulesProfile.create((String)"Sonar way", (String)"xml");
        this.loadActiveKeysFromJsonProfile(profile);
        return profile;
    }

    private void loadActiveKeysFromJsonProfile(RulesProfile rulesProfile) {
        for (String ruleKey : XmlSonarWayProfile.activatedRuleKeys()) {
            Rule rule = this.ruleFinder.findByKey("xml", ruleKey);
            rulesProfile.activateRule(rule, null);
        }
    }

    public static Set<String> activatedRuleKeys() {
        URL profileUrl = XmlSonarWayProfile.class.getResource("/org/sonar/l10n/xml/rules/xml/Sonar_way_profile.json");
        try {
            Gson gson = new Gson();
            return ((Profile)gson.fromJson((String)Resources.toString((URL)profileUrl, (Charset)Charsets.UTF_8), Profile.class)).ruleKeys;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read " + profileUrl, e);
        }
    }

    private static class Profile {
        Set<String> ruleKeys;

        private Profile() {
        }
    }
}

