/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.parsers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import org.sonar.plugins.xml.parsers.AbstractParser;
import org.sonar.plugins.xml.parsers.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class SaxParser
extends AbstractParser {
    private static final String KEY_LINE_NO = "saxParser.lineNumber";
    private static final String KEY_COLUMN_NO = "saxParser.columnNumber";

    public static int getLineNumber(Node node) {
        Integer lineNumber = (Integer)node.getUserData(KEY_LINE_NO);
        return lineNumber == null ? 0 : lineNumber;
    }

    private void parse(InputStream input, DefaultHandler handler, boolean namespaceAware) throws IOException, SAXException {
        SAXParser parser = this.newSaxParser(namespaceAware);
        parser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", handler);
        parser.parse(input, handler);
    }

    public Document parseDocument(InputStream input, boolean namespaceAware) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            LocationRecordingHandler handler = new LocationRecordingHandler(document);
            this.parse(input, handler, namespaceAware);
            return document;
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    private static final class LocationRecordingHandler
    extends DefaultHandler
    implements LexicalHandler {
        private final Document doc;
        private Locator locator;
        private Element current;
        private final Map<String, String> prefixMappings = new HashMap<String, String>();

        public LocationRecordingHandler(Document doc) {
            this.doc = doc;
        }

        @Override
        public void characters(char[] buf, int offset, int length) {
            if (this.current != null) {
                Text n = this.doc.createTextNode(new String(buf, offset, length));
                this.setLocationData(n);
                this.current.appendChild(n);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.current == null) {
                return;
            }
            Node parent = this.current.getParentNode();
            if (parent.getParentNode() == null) {
                this.current.normalize();
                this.current = null;
            } else {
                this.current = (Element)this.current.getParentNode();
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        private void setLocationData(Node n) {
            if (this.locator != null) {
                n.setUserData(SaxParser.KEY_LINE_NO, this.locator.getLineNumber(), null);
                n.setUserData(SaxParser.KEY_COLUMN_NO, this.locator.getColumnNumber(), null);
            }
        }

        @Override
        public void startElement(String uri, @Nullable String localName, String qName, @Nullable Attributes attrs) {
            Element e = localName != null && !"".equals(localName) ? this.doc.createElementNS(uri, localName) : this.doc.createElement(qName);
            this.setLocationData(e);
            if (this.current == null) {
                this.doc.appendChild(e);
            } else {
                this.current.appendChild(e);
            }
            this.current = e;
            for (Map.Entry<String, String> entry : this.prefixMappings.entrySet()) {
                Attr attr = this.doc.createAttribute("xmlns:" + entry.getKey());
                attr.setValue(entry.getValue());
                this.current.setAttributeNodeNS(attr);
            }
            this.prefixMappings.clear();
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr;
                    if (attrs.getLocalName(i) != null && !"".equals(attrs.getLocalName(i))) {
                        attr = this.doc.createAttributeNS(attrs.getURI(i), attrs.getLocalName(i));
                        this.current.setAttributeNodeNS(attr);
                    } else {
                        attr = this.doc.createAttribute(attrs.getQName(i));
                        this.current.setAttributeNode(attr);
                    }
                    attr.setValue(attrs.getValue(i));
                    this.setLocationData(attr);
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.prefixMappings.put(prefix, uri);
        }

        @Override
        public void comment(char[] buf, int offset, int length) throws SAXException {
            Comment n = this.doc.createComment(new String(buf, offset, length));
            this.setLocationData(n);
            if (this.current == null) {
                this.doc.appendChild(n);
            } else {
                this.current.appendChild(n);
            }
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endEntity(String arg0) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void startDTD(String arg0, String arg1, String arg2) throws SAXException {
        }

        @Override
        public void startEntity(String arg0) throws SAXException {
        }
    }
}

