/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.checks.AbstractXmlCheck;
import org.sonar.plugins.xml.checks.XmlIssue;
import org.sonar.plugins.xml.checks.XmlSourceCode;
import org.sonar.plugins.xml.parsers.DetectSchemaParser;
import org.sonar.plugins.xml.schemas.SchemaResolver;
import org.sonar.squidbridge.annotations.RuleTemplate;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

@Rule(key="XmlSchemaCheck")
@RuleTemplate
public class XmlSchemaCheck
extends AbstractXmlCheck {
    @RuleProperty(key="filePattern", description="Files to be validated using Ant-style matching patterns.")
    private String filePattern;
    @RuleProperty(key="schemas", description="Whitespace-separated list of schemas to use for validation.", defaultValue="autodetect", type="TEXT")
    private String schemas;
    private static final Logger LOG = Loggers.get(XmlSchemaCheck.class);
    private static final Map<String, Schema> CACHED_SCHEMAS = new HashMap<String, Schema>();
    public static final String DEFAULT_SCHEMA = "autodetect";

    private Schema createSchema(String[] schemaList) {
        String cacheKey = StringUtils.join((Object[])schemaList, (String)",");
        Schema schema = CACHED_SCHEMAS.get(cacheKey);
        if (schema != null) {
            return schema;
        }
        ArrayList<StreamSource> schemaSources = new ArrayList<StreamSource>();
        for (String schemaReference : schemaList) {
            InputStream input = SchemaResolver.getBuiltinSchema(schemaReference);
            if (input == null) {
                throw new SchemaNotFoundException("Could not load schema \"" + schemaReference + "\"");
            }
            schemaSources.add(new StreamSource(input));
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new SchemaResolver());
            schema = schemaFactory.newSchema(schemaSources.toArray(new Source[schemaSources.size()]));
            CACHED_SCHEMAS.put(cacheKey, schema);
            return schema;
        }
        catch (SAXException e) {
            LOG.warn("Could not validate file {}", (Object)this.getWebSourceCode());
            LOG.warn("Reason: Unable to create schema for [{}]", (Object)cacheKey);
            LOG.warn("Cause:  {}", (Object)e.toString());
            return null;
        }
    }

    private void autodetectSchemaAndValidate() {
        DetectSchemaParser.Doctype doctype = this.detectSchema();
        if (doctype.getDtd() != null) {
            InputStream input = SchemaResolver.getBuiltinSchema(doctype.getDtd());
            if (input == null) {
                LOG.error("Could not validate {} for doctype {}", (Object)this.getWebSourceCode(), (Object)doctype.getDtd());
            } else {
                IOUtils.closeQuietly((InputStream)input);
                this.validate(new String[]{doctype.getDtd()});
            }
        } else if (doctype.getNamespace() != null && !StringUtils.isEmpty((String)doctype.getNamespace())) {
            this.validate(new String[]{doctype.getNamespace()});
        } else {
            LOG.info("Could not autodetect schema for {}, skip validation.", (Object)this.getWebSourceCode());
        }
    }

    private boolean containsMessage(SAXException e) {
        if (e instanceof SAXParseException) {
            SAXParseException spe = (SAXParseException)e;
            for (XmlIssue i : this.getWebSourceCode().getXmlIssues()) {
                if (i.getLine().intValue() != spe.getLineNumber() || !i.getMessage().equals(spe.getMessage())) continue;
                return true;
            }
        }
        return false;
    }

    private DetectSchemaParser.Doctype detectSchema() {
        return new DetectSchemaParser().findDoctype(this.getWebSourceCode().createInputStream());
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public String getSchemas() {
        return this.schemas;
    }

    @VisibleForTesting
    static void setFeature(Validator validator, String feature, boolean value) {
        try {
            validator.setFeature(feature, value);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    private void validate() {
        try {
            if (DEFAULT_SCHEMA.equalsIgnoreCase(this.schemas)) {
                this.autodetectSchemaAndValidate();
            } else {
                String[] schemaList = StringUtils.split((String)this.schemas, (String)" \t\n");
                this.validate(schemaList);
            }
        }
        catch (SchemaNotFoundException e) {
            LOG.warn("Cannot validate file {}", (Object)this.getWebSourceCode());
            LOG.warn("Cause: {}", (Object)e.toString());
        }
    }

    private void validate(String[] schemaList) {
        Schema schema = this.createSchema(schemaList);
        if (schema != null) {
            Validator validator = schema.newValidator();
            XmlSchemaCheck.setFeature(validator, "http://apache.org/xml/features/continue-after-fatal-error", true);
            validator.setErrorHandler(new MessageHandler());
            validator.setResourceResolver(new SchemaResolver());
            try {
                LOG.info("Validating {} with schema {}", (Object)this.getWebSourceCode(), (Object)StringUtils.join((Object[])schemaList, (String)","));
                validator.validate(new StreamSource(this.getWebSourceCode().createInputStream()));
            }
            catch (SAXException e) {
                if (!this.containsMessage(e)) {
                    this.createViolation(0, e.getMessage());
                }
            }
            catch (IOException e) {
                LOG.warn("Unable to validate file {}", (Object)this.getWebSourceCode());
                LOG.warn("Cause: {}", (Object)e.getMessage());
            }
            catch (UnrecoverableParseError e) {
                // empty catch block
            }
        }
    }

    @Override
    public void validate(XmlSourceCode xmlSourceCode) {
        this.setWebSourceCode(xmlSourceCode);
        if (this.schemas != null && this.isFileIncluded(this.filePattern)) {
            this.validate();
        }
    }

    private static class SchemaNotFoundException
    extends RuntimeException {
        SchemaNotFoundException(String msg) {
            super(msg);
        }
    }

    private static class UnrecoverableParseError
    extends RuntimeException {
        static final String FAILUREMESSAGE = "The reference to entity \"null\"";
        private static final long serialVersionUID = 1L;

        public UnrecoverableParseError(SAXParseException e) {
            super(e);
        }
    }

    private class MessageHandler
    implements ErrorHandler {
        private MessageHandler() {
        }

        private void createViolation(SAXParseException e) {
            XmlSchemaCheck.this.createViolation(e.getLineNumber(), e.getLocalizedMessage());
            if (e.getLocalizedMessage().contains("The reference to entity \"null\"")) {
                throw new UnrecoverableParseError(e);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.createViolation(e);
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            this.createViolation(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.createViolation(e);
        }
    }
}

