/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.checks.AbstractXmlCheck;
import org.sonar.plugins.xml.checks.XmlSourceCode;
import org.sonar.squidbridge.annotations.RuleTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Rule(key="XPathCheck")
@RuleTemplate
public class XPathCheck
extends AbstractXmlCheck {
    @RuleProperty(key="expression", description="The XPath query", type="TEXT")
    private String expression;
    @RuleProperty(key="filePattern", description="The files to be validated using Ant-style matching patterns")
    private String filePattern;
    @RuleProperty(key="message", description="The issue message", defaultValue="The XPath expression matches this piece of code")
    private String message;

    private void evaluateXPath() {
        Document document = this.getWebSourceCode().getDocument(this.expression.contains(":"));
        XPathExpression xPathExpression = this.getXPathExpressionForDocument(document);
        try {
            this.evaluateXPathForNodeSet(document, xPathExpression);
        }
        catch (XPathExpressionException exceptionNodeSet) {
            this.evaluateXPathForBoolean(document, xPathExpression);
        }
    }

    private void evaluateXPathForNodeSet(Document document, XPathExpression xPathExpression) throws XPathExpressionException {
        NodeList nodes = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            int lineNumber = this.getWebSourceCode().getLineForNode(nodes.item(i));
            this.createViolation(lineNumber);
        }
    }

    private void evaluateXPathForBoolean(Document document, XPathExpression xPathExpression) {
        try {
            Boolean result = (Boolean)xPathExpression.evaluate(document, XPathConstants.BOOLEAN);
            if (result.booleanValue()) {
                this.createViolation(null);
            }
        }
        catch (XPathExpressionException exceptionBoolean) {
            throw this.createExpressionException(exceptionBoolean);
        }
    }

    private void createViolation(Integer lineNumber) {
        if (this.message == null) {
            this.createViolation(lineNumber, "--");
        } else {
            this.createViolation(lineNumber, this.message);
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public String getMessage() {
        return this.message;
    }

    private XPathExpression getXPathExpressionForDocument(Document document) {
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            PrefixResolverDefault resolver = new PrefixResolverDefault((Node)document.getDocumentElement());
            xpath.setNamespaceContext(new DocumentNamespaceContext((PrefixResolver)resolver));
            return xpath.compile(this.expression);
        }
        catch (XPathExpressionException e) {
            throw this.createExpressionException(e);
        }
    }

    private IllegalStateException createExpressionException(XPathExpressionException e) {
        return new IllegalStateException(String.format("Can't compile XPath expression \"%s\" for rule %s", this.expression, this.getRuleKey()), e);
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public void validate(XmlSourceCode xmlSourceCode) {
        this.setWebSourceCode(xmlSourceCode);
        if (this.expression != null && this.isFileIncluded(this.filePattern)) {
            this.evaluateXPath();
        }
    }

    private static final class DocumentNamespaceContext
    implements NamespaceContext {
        private final PrefixResolver resolver;

        private DocumentNamespaceContext(PrefixResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.resolver.getNamespaceForPrefix(prefix);
        }

        @Override
        public String getPrefix(String uri) {
            return null;
        }

        public Iterator<Object> getPrefixes(String val) {
            return null;
        }
    }
}

