/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.plugins.xml.checks.AbstractXmlCheck;
import org.sonar.plugins.xml.checks.XmlSourceCode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@Rule(key="NewlineCheck")
public class NewlineCheck
extends AbstractXmlCheck {
    private void validateNewline(Node node) {
        boolean newline = false;
        Node lastChild = null;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String textContent;
            short nodeType = child.getNodeType();
            if (nodeType == 8) {
                lastChild = child;
                continue;
            }
            if (nodeType == 1) {
                if (!newline) {
                    this.createViolation(this.getWebSourceCode().getLineForNode(child), "Start every element on a separate line.");
                } else {
                    newline = false;
                }
                lastChild = child;
                continue;
            }
            if (nodeType != 3 || StringUtils.isWhitespace((String)(textContent = child.getTextContent())) && !textContent.contains("\n")) continue;
            newline = true;
        }
        this.validateLastChild(newline, lastChild);
        this.checkChildElements(node);
    }

    private void checkChildElements(Node node) {
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            this.validateNewline(child);
        }
    }

    private void validateLastChild(boolean newlineAfterLastChild, @Nullable Node lastChild) {
        if (!newlineAfterLastChild && lastChild != null) {
            this.createViolation(this.getWebSourceCode().getLineForNode(lastChild), "Missing newline after last element");
        }
    }

    @Override
    public void validate(XmlSourceCode xmlSourceCode) {
        this.setWebSourceCode(xmlSourceCode);
        Document document = this.getWebSourceCode().getDocument(false);
        if (document.getDocumentElement() != null) {
            this.validateNewline(document.getDocumentElement());
        }
    }
}

