/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.toolkit;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.ast.AstXmlPrinter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.sonar.colorizer.HtmlOptions;
import org.sonar.colorizer.HtmlRenderer;
import org.sonar.sslr.toolkit.ConfigurationModel;

public class SourceCodeModel {
    private final ConfigurationModel configurationModel;
    private final HtmlRenderer htmlRenderer = new HtmlRenderer(new HtmlOptions(false, null, false));
    private String sourceCode;
    private AstNode astNode;

    public SourceCodeModel(ConfigurationModel configurationModel) {
        Preconditions.checkNotNull((Object)configurationModel);
        this.configurationModel = configurationModel;
    }

    public void setSourceCode(File source, Charset charset) {
        this.astNode = this.configurationModel.getParser().parse(source);
        try {
            this.sourceCode = Files.toString((File)source, (Charset)charset);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public void setSourceCode(String sourceCode) {
        this.astNode = this.configurationModel.getParser().parse(sourceCode);
        this.sourceCode = sourceCode;
    }

    public String getHighlightedSourceCode() {
        return this.htmlRenderer.render((Reader)new StringReader(this.sourceCode), this.configurationModel.getTokenizers());
    }

    public String getXml() {
        return AstXmlPrinter.print((AstNode)this.astNode);
    }

    public AstNode getAstNode() {
        return this.astNode;
    }
}

