/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyResolver {
    private static final Pattern placeholderPattern = Pattern.compile("\\$\\{([\\w\\.]+)\\}");
    private final Properties props;
    private final Properties resolved;
    private final List<String> queue;
    private Map<String, String> env;

    public PropertyResolver(Properties props, Map<String, String> env) {
        this.props = props;
        this.env = env;
        this.resolved = new Properties();
        this.queue = new LinkedList<String>();
    }

    public Properties resolve() {
        for (Map.Entry<Object, Object> e : this.props.entrySet()) {
            if (this.resolved.containsKey(e.getKey())) continue;
            this.resolveProperty((String)e.getKey());
        }
        return this.resolved;
    }

    private String getValue(String key) {
        String propValue;
        if (key.startsWith("env.")) {
            String envKey = key.substring(4);
            propValue = this.env.get(envKey);
        } else {
            propValue = this.props.getProperty(key);
        }
        return propValue != null ? propValue : "";
    }

    private String resolveProperty(String propKey) {
        String propValue = this.getValue(propKey);
        if (propValue.isEmpty()) {
            this.resolved.setProperty(propKey, propValue);
            return propValue;
        }
        Matcher m = placeholderPattern.matcher(propValue);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String varName;
            String string = varName = null == m.group(1) ? m.group(2) : m.group(1);
            if (this.queue.contains(varName)) {
                throw new IllegalArgumentException("Found a loop resolving place holders in properties, for variable: " + varName);
            }
            String placeholderValue = this.resolveVar(varName);
            m.appendReplacement(sb, Matcher.quoteReplacement(placeholderValue));
        }
        m.appendTail(sb);
        String resolvedPropValue = sb.toString();
        this.resolved.setProperty(propKey, resolvedPropValue);
        return resolvedPropValue;
    }

    private String resolveVar(String varName) {
        String placeholderValue;
        if (this.resolved.containsKey(varName)) {
            placeholderValue = this.resolved.getProperty(varName);
        } else {
            this.queue.add(varName);
            placeholderValue = this.resolveProperty(varName);
            this.queue.remove(varName);
        }
        return placeholderValue;
    }
}

