/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import com.sonarsource.checks.verifier.FileContent;
import com.sonarsource.checks.verifier.internal.Comment;
import java.util.ArrayList;
import java.util.List;

public class SingleLineCommentParser
implements Comment.Parser {
    public final String commentPrefix;

    public SingleLineCommentParser(String commentPrefix) {
        this.commentPrefix = commentPrefix;
    }

    @Override
    public List<Comment> parse(FileContent file) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        String[] lines = file.getContent().split("\r?\n|\r", -1);
        for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
            String line = lines[lineIndex];
            int commentIndex = line.indexOf(this.commentPrefix);
            if (commentIndex == -1) continue;
            int lineNumber = lineIndex + 1;
            int column = commentIndex + 1;
            int contentColumn = column + this.commentPrefix.length();
            String commentContent = line.substring(contentColumn - 1);
            comments.add(new Comment(file.getPath(), lineNumber, column, contentColumn, commentContent));
        }
        return comments;
    }
}

