/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import com.sonarsource.checks.verifier.internal.FlowLocation;
import com.sonarsource.checks.verifier.internal.PreciseLocation;
import com.sonarsource.checks.verifier.internal.SecondaryLocation;
import com.sonarsource.checks.verifier.internal.UnderlinedRange;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class PrimaryLocation
extends PreciseLocation {
    @Nullable
    public Integer expectedAdditionalCount;
    public final List<SecondaryLocation> secondaryLocations = new ArrayList<SecondaryLocation>();
    public final List<List<FlowLocation>> flowLocations = new ArrayList<List<FlowLocation>>();

    public PrimaryLocation(UnderlinedRange range, @Nullable Integer expectedAdditionalCount) {
        super(range);
        this.expectedAdditionalCount = expectedAdditionalCount;
    }

    public int secondaryAndFlowLocationCount() {
        return this.secondaryLocations.size() + this.flowLocations.stream().mapToInt(List::size).sum();
    }

    public SecondaryLocation addSecondary(UnderlinedRange range, @Nullable String message) {
        boolean primaryIsBefore = this.range.compareTo(range) <= 0;
        SecondaryLocation location = new SecondaryLocation(range, primaryIsBefore, this.secondaryLocations.size() + 1, message);
        this.secondaryLocations.add(location);
        return location;
    }

    @Override
    public void write(int indent, StringBuilder out, boolean primaryIsWritten) {
        this.range.underline(indent, out);
        if (this.expectedAdditionalCount != null) {
            out.append(' ').append(this.expectedAdditionalCount);
            int additionalCount = this.secondaryAndFlowLocationCount();
            if (this.expectedAdditionalCount != additionalCount) {
                out.append("[ERROR expect ").append(additionalCount).append("]");
            }
        }
    }
}

