/*
 * Decompiled with CFR 0.152.
 */
package com.sonarsource.checks.verifier.internal;

import com.sonarsource.checks.verifier.CommentParser;
import com.sonarsource.checks.verifier.FileContent;
import com.sonarsource.checks.verifier.MultiFileVerifier;
import com.sonarsource.checks.verifier.SingleFileVerifier;
import com.sonarsource.checks.verifier.internal.Comment;
import com.sonarsource.checks.verifier.internal.InternalIssueVerifier;
import com.sonarsource.checks.verifier.internal.SingleLineCommentParser;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class InternalCommentParser
implements CommentParser {
    private List<Comment.Parser> commentParsers = new ArrayList<Comment.Parser>();

    @Override
    public InternalCommentParser addSingleLineCommentSyntax(String commentPrefix) {
        this.commentParsers.add(new SingleLineCommentParser(commentPrefix));
        return this;
    }

    @Override
    public void parseInto(Path path, MultiFileVerifier verifier) {
        ((InternalIssueVerifier)verifier).addComments(this.parse(path));
    }

    @Override
    public void parseInto(Path path, SingleFileVerifier verifier) {
        ((InternalIssueVerifier)verifier).addComments(this.parse(path));
    }

    private List<Comment> parse(Path path) {
        FileContent file = new FileContent(path.toAbsolutePath());
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Comment.Parser parser : this.commentParsers) {
            comments.addAll(parser.parse(file));
        }
        comments.sort((a, b) -> Integer.compare(a.line, b.line) * 2 + Integer.compare(a.column, b.column));
        return comments;
    }
}

