/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.GroovyPlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.jvm.Jvm;
import org.gradle.listener.ActionBroadcast;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.sonarqube.gradle.SonarQubeExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import org.sonarqube.gradle.SonarQubeTask;

public class SonarQubePlugin
implements Plugin<Project> {
    private static final Predicate<File> FILE_EXISTS = new Predicate<File>(){

        public boolean apply(File input) {
            return input.exists();
        }
    };
    private static final Predicate<File> IS_DIRECTORY = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isDirectory();
        }
    };
    private static final Predicate<File> IS_FILE = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isFile();
        }
    };
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    public static final String SONAR_SOURCES_PROP = "sonar.sources";
    private Project targetProject;

    private static void evaluateSonarPropertiesBlocks(ActionBroadcast<? super SonarQubeProperties> propertiesActions, Map<String, Object> properties) {
        SonarQubeProperties sqProperties = new SonarQubeProperties(properties);
        propertiesActions.execute((Object)sqProperties);
    }

    public void apply(Project project) {
        this.targetProject = project;
        final HashMap actionBroadcastMap = Maps.newHashMap();
        this.createTask(project, actionBroadcastMap);
        ActionBroadcast<SonarQubeProperties> actionBroadcast = SonarQubePlugin.addBroadcaster(actionBroadcastMap, project);
        project.subprojects((Action)new Action<Project>(){

            public void execute(Project project) {
                ActionBroadcast actionBroadcast = SonarQubePlugin.addBroadcaster(actionBroadcastMap, project);
                project.getExtensions().create("sonarqube", SonarQubeExtension.class, new Object[]{actionBroadcast});
            }
        });
        project.getExtensions().create("sonarqube", SonarQubeExtension.class, new Object[]{actionBroadcast});
    }

    private static ActionBroadcast<SonarQubeProperties> addBroadcaster(Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap, Project project) {
        ActionBroadcast actionBroadcast = new ActionBroadcast();
        actionBroadcastMap.put(project, (ActionBroadcast<SonarQubeProperties>)actionBroadcast);
        return actionBroadcast;
    }

    private SonarQubeTask createTask(final Project project, final Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap) {
        SonarQubeTask sonarQubeTask = (SonarQubeTask)project.getTasks().create("sonarqube", SonarQubeTask.class);
        sonarQubeTask.setDescription("Analyzes " + project + " and its subprojects with SonarQube.");
        ConventionMapping conventionMapping = new DslObject((Object)sonarQubeTask).getConventionMapping();
        conventionMapping.map("properties", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LinkedHashMap properties = Maps.newLinkedHashMap();
                SonarQubePlugin.this.computeSonarProperties(project, properties, actionBroadcastMap, "");
                return properties;
            }
        });
        sonarQubeTask.dependsOn(new Object[]{new Callable<Iterable<? extends Task>>(){

            @Override
            public Iterable<? extends Task> call() throws Exception {
                Iterable applicableProjects = Iterables.filter((Iterable)project.getAllprojects(), (Predicate)new Predicate<Project>(){

                    public boolean apply(Project input) {
                        return input.getPlugins().hasPlugin(JavaPlugin.class) && !((SonarQubeExtension)input.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject();
                    }
                });
                return Iterables.transform((Iterable)applicableProjects, (Function)new Function<Project, Task>(){

                    @Nullable
                    public Task apply(Project input) {
                        return input.getTasks().getByName("test");
                    }
                });
            }
        }});
        return sonarQubeTask;
    }

    public void computeSonarProperties(Project project, Map<String, Object> properties, Map<Project, ActionBroadcast<SonarQubeProperties>> sonarPropertiesActionBroadcastMap, String prefix) {
        SonarQubeExtension extension = (SonarQubeExtension)project.getExtensions().getByType(SonarQubeExtension.class);
        if (extension.isSkipProject()) {
            return;
        }
        LinkedHashMap rawProperties = Maps.newLinkedHashMap();
        this.addGradleDefaults(project, rawProperties);
        SonarQubePlugin.evaluateSonarPropertiesBlocks(sonarPropertiesActionBroadcastMap.get(project), rawProperties);
        if (project.equals(this.targetProject)) {
            SonarQubePlugin.addSystemProperties(rawProperties);
        }
        SonarQubePlugin.convertProperties(rawProperties, prefix, properties);
        LinkedList enabledChildProjects = Lists.newLinkedList((Iterable)Iterables.filter(project.getChildProjects().values(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project input) {
                return !((SonarQubeExtension)input.getExtensions().getByType(SonarQubeExtension.class)).isSkipProject();
            }
        }));
        if (enabledChildProjects.isEmpty()) {
            return;
        }
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (Project childProject : enabledChildProjects) {
            String moduleId = SonarQubePlugin.getProjectKey(childProject);
            moduleIds.add(moduleId);
            String modulePrefix = prefix.length() > 0 ? prefix + "." + moduleId : moduleId;
            this.computeSonarProperties(childProject, properties, sonarPropertiesActionBroadcastMap, modulePrefix);
        }
        properties.put(SonarQubePlugin.convertKey("sonar.modules", prefix), COMMA_JOINER.join(moduleIds));
    }

    private void addGradleDefaults(Project project, Map<String, Object> properties) {
        properties.put("sonar.projectName", project.getName());
        properties.put("sonar.projectDescription", project.getDescription());
        properties.put("sonar.projectVersion", project.getVersion());
        properties.put("sonar.projectBaseDir", project.getProjectDir());
        if (project.equals(this.targetProject)) {
            properties.put("sonar.projectKey", SonarQubePlugin.getProjectKey(project));
            properties.put("sonar.working.directory", new File(project.getBuildDir(), "sonar"));
        } else {
            properties.put("sonar.moduleKey", SonarQubePlugin.getProjectKey(project));
        }
        this.configureForJava(project, properties);
        this.configureForGroovy(project, properties);
        if (properties.get(SONAR_SOURCES_PROP) == null) {
            properties.put(SONAR_SOURCES_PROP, "");
        }
    }

    private void configureForJava(final Project project, final Map<String, Object> properties) {
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                SonarQubePlugin.this.configureJdkSourceAndTarget(project, properties);
            }
        });
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                boolean hasSourceOrTest = SonarQubePlugin.this.configureSourceDirsAndJavaClasspath(project, properties);
                if (hasSourceOrTest) {
                    SonarQubePlugin.this.configureSourceEncoding(project, properties);
                    Test testTask = (Test)project.getTasks().getByName("test");
                    SonarQubePlugin.configureTestReports(testTask, properties);
                    SonarQubePlugin.this.configureJaCoCoCoverageReport(testTask, false, project, properties);
                }
            }
        });
    }

    private void configureForGroovy(final Project project, final Map<String, Object> properties) {
        project.getPlugins().withType(GroovyBasePlugin.class, (Action)new Action<GroovyBasePlugin>(){

            public void execute(GroovyBasePlugin groovyBasePlugin) {
                SonarQubePlugin.this.configureJdkSourceAndTarget(project, properties);
            }
        });
        project.getPlugins().withType(GroovyPlugin.class, (Action)new Action<GroovyPlugin>(){

            public void execute(GroovyPlugin groovyPlugin) {
                boolean hasSourceOrTest = SonarQubePlugin.this.configureSourceDirsAndJavaClasspath(project, properties);
                if (hasSourceOrTest) {
                    SonarQubePlugin.this.configureSourceEncoding(project, properties);
                    Test testTask = (Test)project.getTasks().getByName("test");
                    SonarQubePlugin.configureTestReports(testTask, properties);
                    SonarQubePlugin.this.configureJaCoCoCoverageReport(testTask, true, project, properties);
                }
            }
        });
    }

    private void configureJaCoCoCoverageReport(final Test testTask, final boolean addForGroovy, Project project, final Map<String, Object> properties) {
        project.getPlugins().withType(JacocoPlugin.class, (Action)new Action<JacocoPlugin>(){

            public void execute(JacocoPlugin jacocoPlugin) {
                JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)testTask.getExtensions().getByType(JacocoTaskExtension.class);
                File destinationFile = jacocoTaskExtension.getDestinationFile();
                if (destinationFile.exists()) {
                    properties.put("sonar.jacoco.reportPath", destinationFile);
                    if (addForGroovy) {
                        properties.put("sonar.groovy.jacoco.reportPath", destinationFile);
                    }
                }
            }
        });
    }

    private static void configureTestReports(Test testTask, Map<String, Object> properties) {
        File testResultsDir = testTask.getReports().getJunitXml().getDestination();
        try {
            Files.createDirectories(testResultsDir.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create test report directory", e);
        }
        properties.put("sonar.junit.reportsPath", testResultsDir);
        properties.put("sonar.surefire.reportsPath", testResultsDir);
    }

    private boolean configureSourceDirsAndJavaClasspath(Project project, Map<String, Object> properties) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        SourceSet main = (SourceSet)javaPluginConvention.getSourceSets().getAt("main");
        List sourceDirectories = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)main.getAllSource().getSrcDirs(), FILE_EXISTS));
        properties.put(SONAR_SOURCES_PROP, sourceDirectories);
        SourceSet test = (SourceSet)javaPluginConvention.getSourceSets().getAt("test");
        List testDirectories = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)test.getAllSource().getSrcDirs(), FILE_EXISTS));
        properties.put("sonar.tests", testDirectories);
        List mainClasspath = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)main.getRuntimeClasspath(), IS_DIRECTORY));
        Collection<File> mainLibraries = SonarQubePlugin.getLibraries(main);
        properties.put("sonar.java.binaries", mainClasspath);
        properties.put("sonar.java.libraries", mainLibraries);
        List testClasspath = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)test.getRuntimeClasspath(), IS_DIRECTORY));
        Collection<File> testLibraries = SonarQubePlugin.getLibraries(test);
        properties.put("sonar.java.test.binaries", testClasspath);
        properties.put("sonar.java.test.libraries", testLibraries);
        properties.put("sonar.binaries", mainClasspath);
        properties.put("sonar.libraries", mainLibraries);
        return sourceDirectories != null || testDirectories != null;
    }

    private void configureSourceEncoding(Project project, final Map<String, Object> properties) {
        project.getTasks().withType(JavaCompile.class, (Action)new Action<JavaCompile>(){

            public void execute(JavaCompile compile) {
                String encoding = compile.getOptions().getEncoding();
                if (encoding != null) {
                    properties.put("sonar.sourceEncoding", encoding);
                }
            }
        });
    }

    private void configureJdkSourceAndTarget(Project project, Map<String, Object> properties) {
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
        properties.put("sonar.java.source", javaPluginConvention.getSourceCompatibility());
        properties.put("sonar.java.target", javaPluginConvention.getTargetCompatibility());
    }

    private static String getProjectKey(Project project) {
        String name = project.getName();
        String group = project.getGroup().toString();
        return group.isEmpty() ? name : group + ":" + name;
    }

    private static void addSystemProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("sonar")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private static Collection<File> getLibraries(SourceSet main) {
        LinkedList libraries = Lists.newLinkedList((Iterable)Iterables.filter((Iterable)main.getRuntimeClasspath(), IS_FILE));
        File runtimeJar = Jvm.current().getRuntimeJar();
        if (runtimeJar != null) {
            libraries.add(runtimeJar);
        }
        return libraries;
    }

    private static void convertProperties(Map<String, Object> rawProperties, String projectPrefix, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String value = SonarQubePlugin.convertValue(entry.getValue());
            if (value == null) continue;
            properties.put(SonarQubePlugin.convertKey(entry.getKey(), projectPrefix), value);
        }
    }

    private static String convertKey(String key, String projectPrefix) {
        return projectPrefix.isEmpty() ? key : projectPrefix + "." + key;
    }

    private static String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            Iterable flattened = Iterables.transform((Iterable)((Iterable)value), (Function)new Function<Object, String>(){

                public String apply(Object input) {
                    return SonarQubePlugin.convertValue(input);
                }
            });
            Iterable filtered = Iterables.filter((Iterable)flattened, (Predicate)Predicates.notNull());
            String joined = COMMA_JOINER.join(filtered);
            return joined.isEmpty() ? null : joined;
        }
        return value.toString();
    }

    @Nullable
    public static <T> List<T> nonEmptyOrNull(Iterable<T> iterable) {
        ImmutableList list = ImmutableList.copyOf(iterable);
        return list.isEmpty() ? null : list;
    }
}

