/*
 * Decompiled with CFR 0.152.
 */
package org.sonarqube.gradle;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.jvm.Jvm;
import org.gradle.listener.ActionBroadcast;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.plugins.JacocoTaskExtension;
import org.sonarqube.gradle.SonarQubeProperties;
import org.sonarqube.gradle.SonarRunnerExtension;
import org.sonarqube.gradle.SonarRunnerTask;

public class SonarQubePlugin
implements Plugin<Project> {
    private static final Predicate<File> FILE_EXISTS = new Predicate<File>(){

        public boolean apply(File input) {
            return input.exists();
        }
    };
    private static final Predicate<File> IS_DIRECTORY = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isDirectory();
        }
    };
    private static final Predicate<File> IS_FILE = new Predicate<File>(){

        public boolean apply(File input) {
            return input.isFile();
        }
    };
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private Project targetProject;

    private static void evaluateSonarPropertiesBlocks(ActionBroadcast<? super SonarQubeProperties> propertiesActions, Map<String, Object> properties) {
        SonarQubeProperties sqProperties = new SonarQubeProperties(properties);
        propertiesActions.execute((Object)sqProperties);
    }

    public void apply(Project project) {
        this.targetProject = project;
        final HashMap actionBroadcastMap = Maps.newHashMap();
        SonarRunnerTask sonarRunnerTask = this.createTask(project, actionBroadcastMap);
        ActionBroadcast<SonarQubeProperties> actionBroadcast = this.addBroadcaster(actionBroadcastMap, project);
        project.subprojects((Action)new Action<Project>(){

            public void execute(Project project) {
                ActionBroadcast actionBroadcast = SonarQubePlugin.this.addBroadcaster(actionBroadcastMap, project);
                project.getExtensions().create("sonarRunner", SonarRunnerExtension.class, new Object[]{actionBroadcast});
            }
        });
        project.getExtensions().create("sonarRunner", SonarRunnerExtension.class, new Object[]{actionBroadcast});
    }

    private ActionBroadcast<SonarQubeProperties> addBroadcaster(Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap, Project project) {
        ActionBroadcast actionBroadcast = new ActionBroadcast();
        actionBroadcastMap.put(project, (ActionBroadcast<SonarQubeProperties>)actionBroadcast);
        return actionBroadcast;
    }

    private SonarRunnerTask createTask(final Project project, final Map<Project, ActionBroadcast<SonarQubeProperties>> actionBroadcastMap) {
        SonarRunnerTask sonarRunnerTask = (SonarRunnerTask)project.getTasks().create("sonarRunner", SonarRunnerTask.class);
        sonarRunnerTask.setDescription("Analyzes " + project + " and its subprojects with SonarQube Runner.");
        ConventionMapping conventionMapping = new DslObject((Object)sonarRunnerTask).getConventionMapping();
        conventionMapping.map("sonarProperties", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LinkedHashMap properties = Maps.newLinkedHashMap();
                SonarQubePlugin.this.computeSonarProperties(project, properties, actionBroadcastMap, "");
                return properties;
            }
        });
        sonarRunnerTask.dependsOn(new Object[]{new Callable<Iterable<? extends Task>>(){

            @Override
            public Iterable<? extends Task> call() throws Exception {
                Iterable applicableProjects = Iterables.filter((Iterable)project.getAllprojects(), (Predicate)new Predicate<Project>(){

                    public boolean apply(Project input) {
                        return input.getPlugins().hasPlugin(JavaPlugin.class) && !((SonarRunnerExtension)input.getExtensions().getByType(SonarRunnerExtension.class)).isSkipProject();
                    }
                });
                return Iterables.transform((Iterable)applicableProjects, (Function)new Function<Project, Task>(){

                    @Nullable
                    public Task apply(Project input) {
                        return input.getTasks().getByName("test");
                    }
                });
            }
        }});
        return sonarRunnerTask;
    }

    public void computeSonarProperties(Project project, Map<String, Object> properties, Map<Project, ActionBroadcast<SonarQubeProperties>> sonarPropertiesActionBroadcastMap, String prefix) {
        SonarRunnerExtension extension = (SonarRunnerExtension)project.getExtensions().getByType(SonarRunnerExtension.class);
        if (extension.isSkipProject()) {
            return;
        }
        LinkedHashMap rawProperties = Maps.newLinkedHashMap();
        this.addGradleDefaults(project, rawProperties);
        SonarQubePlugin.evaluateSonarPropertiesBlocks(sonarPropertiesActionBroadcastMap.get(project), rawProperties);
        if (project.equals(this.targetProject)) {
            this.addSystemProperties(rawProperties);
        }
        this.convertProperties(rawProperties, prefix, properties);
        LinkedList enabledChildProjects = Lists.newLinkedList((Iterable)Iterables.filter(project.getChildProjects().values(), (Predicate)new Predicate<Project>(){

            public boolean apply(Project input) {
                return !((SonarRunnerExtension)input.getExtensions().getByType(SonarRunnerExtension.class)).isSkipProject();
            }
        }));
        if (enabledChildProjects.isEmpty()) {
            return;
        }
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (Project childProject : enabledChildProjects) {
            String moduleId = this.getProjectKey(childProject);
            moduleIds.add(moduleId);
            String modulePrefix = prefix.length() > 0 ? prefix + "." + moduleId : moduleId;
            this.computeSonarProperties(childProject, properties, sonarPropertiesActionBroadcastMap, modulePrefix);
        }
        properties.put(this.convertKey("sonar.modules", prefix), COMMA_JOINER.join(moduleIds));
    }

    private void addGradleDefaults(final Project project, final Map<String, Object> properties) {
        properties.put("sonar.projectName", project.getName());
        properties.put("sonar.projectDescription", project.getDescription());
        properties.put("sonar.projectVersion", project.getVersion());
        properties.put("sonar.projectBaseDir", project.getProjectDir());
        properties.put("sonar.dynamicAnalysis", "reuseReports");
        if (project.equals(this.targetProject)) {
            properties.put("sonar.projectKey", this.getProjectKey(project));
            properties.put("sonar.working.directory", new File(project.getBuildDir(), "sonar"));
        } else {
            properties.put("sonar.moduleKey", this.getProjectKey(project));
        }
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
                properties.put("sonar.java.source", javaPluginConvention.getSourceCompatibility());
                properties.put("sonar.java.target", javaPluginConvention.getTargetCompatibility());
            }
        });
        project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

            public void execute(JavaPlugin javaPlugin) {
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)new DslObject((Object)project).getConvention().getPlugin(JavaPluginConvention.class);
                SourceSet main = (SourceSet)javaPluginConvention.getSourceSets().getAt("main");
                List sourceDirectories = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)main.getAllSource().getSrcDirs(), (Predicate)FILE_EXISTS));
                properties.put("sonar.sources", sourceDirectories);
                SourceSet test = (SourceSet)javaPluginConvention.getSourceSets().getAt("test");
                List testDirectories = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)test.getAllSource().getSrcDirs(), (Predicate)FILE_EXISTS));
                properties.put("sonar.tests", testDirectories);
                List mainClasspath = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)main.getRuntimeClasspath(), (Predicate)IS_DIRECTORY));
                Collection mainLibraries = SonarQubePlugin.this.getLibraries(main);
                properties.put("sonar.java.binaries", mainClasspath);
                properties.put("sonar.java.libraries", mainLibraries);
                List testClasspath = SonarQubePlugin.nonEmptyOrNull(Iterables.filter((Iterable)test.getRuntimeClasspath(), (Predicate)IS_DIRECTORY));
                Collection testLibraries = SonarQubePlugin.this.getLibraries(test);
                properties.put("sonar.java.test.binaries", testClasspath);
                properties.put("sonar.java.test.libraries", testLibraries);
                properties.put("sonar.binaries", mainClasspath);
                properties.put("sonar.libraries", mainLibraries);
                final Test testTask = (Test)project.getTasks().getByName("test");
                if (sourceDirectories != null || testDirectories != null) {
                    File testResultsDir = testTask.getReports().getJunitXml().getDestination();
                    testResultsDir.mkdirs();
                    properties.put("sonar.surefire.reportsPath", testResultsDir);
                    properties.put("sonar.junit.reportsPath", testResultsDir);
                }
                project.getPlugins().withType(JacocoPlugin.class, (Action)new Action<JacocoPlugin>(){

                    public void execute(JacocoPlugin jacocoPlugin) {
                        JacocoTaskExtension jacocoTaskExtension = (JacocoTaskExtension)testTask.getExtensions().getByType(JacocoTaskExtension.class);
                        File destinationFile = jacocoTaskExtension.getDestinationFile();
                        if (destinationFile.exists()) {
                            properties.put("sonar.jacoco.reportPath", destinationFile);
                        }
                    }
                });
            }
        });
        if (properties.get("sonar.sources") == null) {
            properties.put("sonar.sources", "");
        }
    }

    private String getProjectKey(Project project) {
        String name = project.getName();
        String group = project.getGroup().toString();
        return group.isEmpty() ? name : group + ":" + name;
    }

    private void addSystemProperties(Map<String, Object> properties) {
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith("sonar")) continue;
            properties.put(key, entry.getValue());
        }
    }

    private Collection<File> getLibraries(SourceSet main) {
        LinkedList libraries = Lists.newLinkedList((Iterable)Iterables.filter((Iterable)main.getRuntimeClasspath(), IS_FILE));
        File runtimeJar = Jvm.current().getRuntimeJar();
        if (runtimeJar != null) {
            libraries.add(runtimeJar);
        }
        return libraries;
    }

    private void convertProperties(Map<String, Object> rawProperties, String projectPrefix, Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : rawProperties.entrySet()) {
            String value = this.convertValue(entry.getValue());
            if (value == null) continue;
            properties.put(this.convertKey(entry.getKey(), projectPrefix), value);
        }
    }

    private String convertKey(String key, String projectPrefix) {
        return projectPrefix.isEmpty() ? key : projectPrefix + "." + key;
    }

    private String convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            Iterable flattened = Iterables.transform((Iterable)((Iterable)value), (Function)new Function<Object, String>(){

                public String apply(Object input) {
                    return SonarQubePlugin.this.convertValue(input);
                }
            });
            Iterable filtered = Iterables.filter((Iterable)flattened, (Predicate)Predicates.notNull());
            String joined = COMMA_JOINER.join(filtered);
            return joined.isEmpty() ? null : joined;
        }
        return value.toString();
    }

    @Nullable
    public static <T> List<T> nonEmptyOrNull(Iterable<T> iterable) {
        ImmutableList list = ImmutableList.copyOf(iterable);
        return list.isEmpty() ? null : list;
    }
}

