/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.httpclient;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.siouan.frontendgradleplugin.domain.installer.AbstractHttpClient;
import org.siouan.frontendgradleplugin.domain.installer.Credentials;
import org.siouan.frontendgradleplugin.domain.installer.HttpResponse;
import org.siouan.frontendgradleplugin.domain.installer.ProxySettings;
import org.siouan.frontendgradleplugin.infrastructure.httpclient.ApacheHttpResponse;

public class ApacheHttpClient
extends AbstractHttpClient {
    @Override
    protected HttpResponse getRemoteResource(URL resourceUrl, Credentials credentials, ProxySettings proxySettings) throws IOException {
        HttpHost proxyServerHost;
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        ContextBuilder contextBuilder = ContextBuilder.create();
        if (credentials != null) {
            this.registerCredentials(contextBuilder, new HttpHost(resourceUrl.getProtocol(), resourceUrl.getHost(), resourceUrl.getPort()), credentials.getUsername(), credentials.getPassword());
        }
        if (proxySettings.getProxyType() == Proxy.Type.DIRECT) {
            proxyServerHost = null;
        } else {
            proxyServerHost = new HttpHost(proxySettings.getProxyHost(), proxySettings.getProxyPort());
            Credentials proxyCredentials = proxySettings.getCredentials();
            if (proxyCredentials != null) {
                this.registerCredentials(contextBuilder, proxyServerHost, proxyCredentials.getUsername(), proxyCredentials.getPassword());
            }
        }
        HttpGet httpGet = new HttpGet(resourceUrl.toString());
        httpGet.setConfig(requestConfigBuilder.build());
        CloseableHttpClient httpClient = HttpClients.custom().setProxy(proxyServerHost).build();
        try {
            return new ApacheHttpResponse(httpClient, httpClient.executeOpen(null, (ClassicHttpRequest)httpGet, (HttpContext)contextBuilder.build()));
        }
        catch (IOException e) {
            httpClient.close();
            throw e;
        }
    }

    private void registerCredentials(ContextBuilder contextBuilder, HttpHost host, String username, String password) {
        contextBuilder.preemptiveBasicAuth(host, new UsernamePasswordCredentials(username, password.toCharArray()));
    }
}

