/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.InvalidJsonFileException;
import org.siouan.frontendgradleplugin.domain.MalformedPackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.Platform;
import org.siouan.frontendgradleplugin.domain.ResolvePackageManager;
import org.siouan.frontendgradleplugin.domain.ResolvePackageManagerCommand;
import org.siouan.frontendgradleplugin.domain.UnsupportedPackageManagerException;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.bean.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.bean.ZeroOrMultiplePublicConstructorsException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.BeanRegistryBuildService;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleLoggerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerInitializer;

@CacheableTask
public class ResolvePackageManagerTask
extends DefaultTask {
    protected final Property<BeanRegistryBuildService> beanRegistryBuildService;
    private final RegularFileProperty packageJsonFile;
    private final Property<File> nodeInstallDirectory;
    private final RegularFileProperty packageManagerSpecificationFile;
    private final RegularFileProperty packageManagerExecutablePathFile;
    private final Property<Boolean> verboseModeEnabled;
    private final Property<String> systemJvmArch;
    private final Property<String> systemOsName;

    @Inject
    public ResolvePackageManagerTask(ObjectFactory objectFactory) {
        this.beanRegistryBuildService = objectFactory.property(BeanRegistryBuildService.class);
        this.packageJsonFile = objectFactory.fileProperty();
        this.nodeInstallDirectory = objectFactory.property(File.class);
        this.packageManagerSpecificationFile = objectFactory.fileProperty();
        this.packageManagerExecutablePathFile = objectFactory.fileProperty();
        this.verboseModeEnabled = objectFactory.property(Boolean.class);
        this.systemJvmArch = objectFactory.property(String.class);
        this.systemOsName = objectFactory.property(String.class);
    }

    @Internal
    public Property<BeanRegistryBuildService> getBeanRegistryBuildService() {
        return this.beanRegistryBuildService;
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @Optional
    public RegularFileProperty getPackageJsonFile() {
        return this.packageJsonFile;
    }

    @Input
    public Property<File> getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @Internal
    public Property<Boolean> getVerboseModeEnabled() {
        return this.verboseModeEnabled;
    }

    @Internal
    public Property<String> getSystemJvmArch() {
        return this.systemJvmArch;
    }

    @Internal
    public Property<String> getSystemOsName() {
        return this.systemOsName;
    }

    @OutputFile
    public RegularFileProperty getPackageManagerSpecificationFile() {
        return this.packageManagerSpecificationFile;
    }

    @OutputFile
    public RegularFileProperty getPackageManagerExecutablePathFile() {
        return this.packageManagerExecutablePathFile;
    }

    @TaskAction
    public void execute() throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException, IOException, InvalidJsonFileException, MalformedPackageManagerSpecification, UnsupportedPackageManagerException {
        BeanRegistry beanRegistry = ((BeanRegistryBuildService)this.beanRegistryBuildService.get()).getBeanRegistry();
        TaskLoggerInitializer.initAdapter((Task)this, (Boolean)this.verboseModeEnabled.get(), beanRegistry.getBean(GradleLoggerAdapter.class), beanRegistry.getBean(GradleSettings.class));
        Platform platform = Platform.builder().jvmArch((String)this.systemJvmArch.get()).osName((String)this.systemOsName.get()).build();
        this.getLogger().debug("Platform: {}", (Object)platform);
        beanRegistry.getBean(ResolvePackageManager.class).execute(ResolvePackageManagerCommand.builder().packageJsonFilePath((Path)this.packageJsonFile.getAsFile().map(File::toPath).getOrNull()).nodeInstallDirectoryPath((Path)this.nodeInstallDirectory.map(File::toPath).get()).platform(platform).packageManagerSpecificationFilePath(((File)this.packageManagerSpecificationFile.getAsFile().get()).toPath()).packageManagerExecutablePathFilePath(((File)this.packageManagerExecutablePathFile.getAsFile().get()).toPath()).build());
    }
}

