/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.process.ExecOperations;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.infrastructure.bean.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AbstractRunCommandTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.NonRunnableTaskException;

public class InstallCorepackTask
extends AbstractRunCommandTask {
    private static final String INSTALL_COREPACK_COMMAND = "install -g corepack";
    public static final String LATEST_VERSION_ARGUMENT = "latest";
    public static final String COREPACK_MODULE_PATH = "node_modules/corepack";
    public static final String COREPACK_ENABLE_STRICT_VARIABLE = "COREPACK_ENABLE_STRICT";
    private final Property<String> corepackVersion;
    private final DirectoryProperty corepackModuleDirectory;

    @Inject
    public InstallCorepackTask(ObjectFactory objectFactory, ExecOperations execOperations) {
        super(objectFactory, execOperations);
        this.executableType.set((Object)ExecutableType.NPM);
        this.corepackVersion = objectFactory.property(String.class);
        this.corepackModuleDirectory = objectFactory.directoryProperty();
        this.corepackModuleDirectory.set(this.getProject().getLayout().dir(this.getNodeInstallDirectory().map(f -> f.toPath().resolve(COREPACK_MODULE_PATH).toFile())));
    }

    @Input
    public Property<String> getCorepackVersion() {
        return this.corepackVersion;
    }

    @OutputDirectory
    public DirectoryProperty getCorepackModuleDirectory() {
        return this.corepackModuleDirectory;
    }

    @Override
    public void execute() throws NonRunnableTaskException, BeanRegistryException {
        StringBuilder scriptBuilder = new StringBuilder(INSTALL_COREPACK_COMMAND);
        String version = (String)this.corepackVersion.get();
        if (!version.equals(LATEST_VERSION_ARGUMENT)) {
            scriptBuilder.append("@");
            scriptBuilder.append(version);
        }
        this.executableArgs.set((Object)scriptBuilder.toString());
        this.environmentVariables.put((Object)COREPACK_ENABLE_STRICT_VARIABLE, (Object)"0");
        super.execute();
    }
}

