/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.Serializable;
import org.gradle.api.logging.LogLevel;
import org.siouan.frontendgradleplugin.domain.Logger;

public class GradleLoggerAdapter
implements Logger,
Serializable {
    private static final long serialVersionUID = 7961046158160963130L;
    private transient org.gradle.api.logging.Logger gradleLogger;
    private LogLevel loggingLevel = LogLevel.LIFECYCLE;
    private boolean verboseModeEnabled = false;
    private transient String prefix;

    public void init(org.gradle.api.logging.Logger gradleLogger, LogLevel loggingLevel, boolean verboseModeEnabled, String prefix) {
        this.gradleLogger = gradleLogger;
        this.loggingLevel = loggingLevel;
        this.verboseModeEnabled = verboseModeEnabled;
        this.prefix = prefix;
    }

    @Override
    public void debug(String message, Object ... parameters) {
        if (this.gradleLogger != null && this.gradleLogger.isDebugEnabled()) {
            this.gradleLogger.debug(this.formatMessage(message), parameters);
        }
    }

    @Override
    public void info(String message, Object ... parameters) {
        this.logWithDefaultLevel(LogLevel.INFO, message, parameters);
    }

    @Override
    public void warn(String message, Object ... parameters) {
        this.logWithDefaultLevel(LogLevel.WARN, message, parameters);
    }

    private void logWithDefaultLevel(LogLevel defaultLoggingLevel, String message, Object ... parameters) {
        if (this.gradleLogger == null) {
            return;
        }
        if (this.verboseModeEnabled) {
            this.gradleLogger.log(this.loggingLevel, this.formatMessage(message), parameters);
        } else {
            this.gradleLogger.log(defaultLoggingLevel, this.formatMessage(message), parameters);
        }
    }

    private String formatMessage(String message) {
        return this.prefix == null ? message : this.prefix + message;
    }
}

