/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import lombok.Generated;
import org.siouan.frontendgradleplugin.domain.ExecutableType;
import org.siouan.frontendgradleplugin.domain.ExecutionSettings;
import org.siouan.frontendgradleplugin.domain.GetExecutablePath;
import org.siouan.frontendgradleplugin.domain.GetExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveExecutablePathCommand;
import org.siouan.frontendgradleplugin.domain.ResolveExecutionSettingsCommand;
import org.siouan.frontendgradleplugin.domain.ResolveNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.StringSplitter;

public class ResolveExecutionSettings {
    public static final Path WINDOWS_EXECUTABLE_PATH = Paths.get("cmd", new String[0]);
    public static final String WINDOWS_EXECUTABLE_AUTOEXIT_FLAG = "/c";
    public static final Path UNIX_EXECUTABLE_PATH = Paths.get("/bin", "sh");
    public static final String UNIX_EXECUTABLE_AUTOEXIT_FLAG = "-c";
    public static final char UNIX_SCRIPT_ARG_SEPARATOR_CHAR = ' ';
    public static final char UNIX_SCRIPT_ARG_ESCAPE_CHAR = '\\';
    private final ResolveNodeExecutablePath getNodeExecutablePath;
    private final GetExecutablePath getExecutablePath;

    public ExecutionSettings execute(ResolveExecutionSettingsCommand command) {
        Path nodeExecutableParentPath;
        Path executable;
        Path nodeExecutablePath = this.getNodeExecutablePath.execute(ResolveExecutablePathCommand.builder().nodeInstallDirectoryPath(command.getNodeInstallDirectoryPath()).platform(command.getPlatform()).build());
        Path executablePath = this.getExecutablePath.execute(GetExecutablePathCommand.builder().executableType(command.getExecutableType()).nodeInstallDirectoryPath(command.getNodeInstallDirectoryPath()).platform(command.getPlatform()).build());
        ArrayList<String> args = new ArrayList<String>();
        if (command.getPlatform().isWindowsOs()) {
            executable = WINDOWS_EXECUTABLE_PATH;
            args.add(WINDOWS_EXECUTABLE_AUTOEXIT_FLAG);
            args.add(this.escapeWhitespacesFromCommandLineToken(executablePath) + " " + command.getExecutableArgs().trim());
        } else {
            executable = UNIX_EXECUTABLE_PATH;
            args.add(UNIX_EXECUTABLE_AUTOEXIT_FLAG);
            args.add(this.escapeWhitespacesFromCommandLineToken(executablePath) + " " + String.join((CharSequence)Character.toString(' '), new StringSplitter(' ', '\\').execute(command.getExecutableArgs().trim())));
        }
        HashSet<Path> executablePaths = new HashSet<Path>();
        if (command.getExecutableType() != ExecutableType.NODE && (nodeExecutableParentPath = nodeExecutablePath.getParent()) != null) {
            executablePaths.add(nodeExecutableParentPath);
        }
        return new ExecutionSettings(command.getPackageJsonDirectoryPath(), executablePaths, executable, args, command.getEnvironmentVariables());
    }

    private String escapeWhitespacesFromCommandLineToken(Path path) {
        return "\"" + path.toString() + "\"";
    }

    @Generated
    public ResolveExecutionSettings(ResolveNodeExecutablePath getNodeExecutablePath, GetExecutablePath getExecutablePath) {
        this.getNodeExecutablePath = getNodeExecutablePath;
        this.getExecutablePath = getExecutablePath;
    }
}

