/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.siouan.frontendgradleplugin.domain.MalformedPackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.PackageManager;
import org.siouan.frontendgradleplugin.domain.PackageManagerType;
import org.siouan.frontendgradleplugin.domain.UnsupportedPackageManagerException;

public class ParsePackageManagerSpecification {
    private static final String PACKAGE_MANAGER_NAME_GROUP = "packageManagerName";
    private static final String PACKAGE_MANAGER_VERSION_GROUP = "packageManagerVersion";
    private static final Pattern PACKAGE_MANAGER_PATTERN = Pattern.compile("^(?<packageManagerName>[\\w\\-]+)@(?<packageManagerVersion>\\d+\\.\\d+\\.\\d+)(?:\\+.*)?$");

    public PackageManager execute(String packageManagerSpecification) throws MalformedPackageManagerSpecification, UnsupportedPackageManagerException {
        Matcher matcher = PACKAGE_MANAGER_PATTERN.matcher(packageManagerSpecification);
        if (!matcher.matches()) {
            throw new MalformedPackageManagerSpecification(packageManagerSpecification);
        }
        String packageManagerName = matcher.group(PACKAGE_MANAGER_NAME_GROUP);
        String packageManagerVersion = matcher.group(PACKAGE_MANAGER_VERSION_GROUP);
        return PackageManager.builder().type(PackageManagerType.fromPackageManagerName(packageManagerName).orElseThrow(() -> new UnsupportedPackageManagerException(packageManagerName))).version(packageManagerVersion).build();
    }
}

