/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import lombok.Generated;
import org.json.JSONException;
import org.json.JSONObject;
import org.siouan.frontendgradleplugin.domain.FileManager;
import org.siouan.frontendgradleplugin.domain.InvalidJsonFileException;
import org.siouan.frontendgradleplugin.domain.Logger;
import org.siouan.frontendgradleplugin.domain.MalformedPackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.PackageManager;
import org.siouan.frontendgradleplugin.domain.ParsePackageManagerSpecification;
import org.siouan.frontendgradleplugin.domain.UnsupportedPackageManagerException;

public class ParsePackageManagerFromPackageJsonFile {
    private static final String PACKAGE_MANAGER_KEY = "packageManager";
    private final FileManager fileManager;
    private final ParsePackageManagerSpecification parsePackageManagerSpecification;
    private final Logger logger;

    public PackageManager execute(Path packageJsonFilePath) throws InvalidJsonFileException, UnsupportedPackageManagerException, IOException, MalformedPackageManagerSpecification {
        String packageManagerSpecification;
        try {
            JSONObject packageJsonFileObject = new JSONObject(this.fileManager.readString(packageJsonFilePath, StandardCharsets.UTF_8));
            packageManagerSpecification = packageJsonFileObject.getString(PACKAGE_MANAGER_KEY);
        }
        catch (JSONException e) {
            throw new InvalidJsonFileException(packageJsonFilePath);
        }
        PackageManager packageManager = this.parsePackageManagerSpecification.execute(packageManagerSpecification);
        this.logger.info("Package manager: {} v{}", packageManager.type().getPackageManagerName(), packageManager.version());
        return packageManager;
    }

    @Generated
    public ParsePackageManagerFromPackageJsonFile(FileManager fileManager, ParsePackageManagerSpecification parsePackageManagerSpecification, Logger logger) {
        this.fileManager = fileManager;
        this.parsePackageManagerSpecification = parsePackageManagerSpecification;
        this.logger = logger;
    }
}

