/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.provider.Provider;
import org.siouan.frontendgradleplugin.domain.model.SystemProperty;
import org.siouan.frontendgradleplugin.domain.model.SystemSettingsProvider;
import org.siouan.frontendgradleplugin.infrastructure.gradle.SystemExtension;

public class SystemSettingsProviderImpl
implements SystemSettingsProvider {
    private final Provider<String> httpProxyHost;
    private final Provider<String> httpProxyPort;
    private final Provider<String> httpsProxyHost;
    private final Provider<String> httpsProxyPort;
    private final Provider<String> nonProxyHosts;
    private final Provider<String> jvmArch;
    private final Provider<String> osName;
    private final Provider<String> nodejsHomePath;
    private final int defaultHttpProxyPort;
    private final int defaultHttpsProxyPort;

    public SystemSettingsProviderImpl(@Nonnull SystemExtension systemExtension, int defaultHttpProxyPort, int defaultHttpsProxyPort) {
        this.httpProxyHost = systemExtension.getHttpProxyHost();
        this.httpProxyPort = systemExtension.getHttpProxyPort();
        this.httpsProxyHost = systemExtension.getHttpsProxyHost();
        this.httpsProxyPort = systemExtension.getHttpsProxyPort();
        this.nonProxyHosts = systemExtension.getNonProxyHosts();
        this.jvmArch = systemExtension.getJvmArch();
        this.osName = systemExtension.getOsName();
        this.nodejsHomePath = systemExtension.getNodejsHomePath();
        this.defaultHttpProxyPort = defaultHttpProxyPort;
        this.defaultHttpsProxyPort = defaultHttpsProxyPort;
    }

    @Override
    @Nullable
    public String getHttpProxyHost() {
        return (String)this.httpProxyHost.getOrNull();
    }

    @Override
    public int getHttpProxyPort() {
        return Optional.ofNullable(this.httpProxyPort.getOrNull()).filter(port -> !port.trim().isEmpty()).map(Integer::parseInt).orElse(this.defaultHttpProxyPort);
    }

    @Override
    @Nullable
    public String getHttpsProxyHost() {
        return (String)this.httpsProxyHost.getOrNull();
    }

    @Override
    public int getHttpsProxyPort() {
        return Optional.ofNullable(this.httpsProxyPort.getOrNull()).filter(port -> !port.trim().isEmpty()).map(Integer::parseInt).orElse(this.defaultHttpsProxyPort);
    }

    @Override
    @Nonnull
    public Set<String> getNonProxyHosts() {
        return new HashSet<String>(Optional.ofNullable(this.nonProxyHosts.getOrNull()).filter(v -> !v.trim().isEmpty()).map(hosts -> Arrays.asList(hosts.split(SystemProperty.NON_PROXY_HOSTS_SPLIT_PATTERN))).orElseGet(Collections::emptyList));
    }

    @Override
    @Nonnull
    public String getSystemJvmArch() {
        return (String)this.jvmArch.get();
    }

    @Override
    @Nonnull
    public String getSystemOsName() {
        return (String)this.osName.get();
    }

    @Override
    @Nullable
    public Path getNodejsHomePath() {
        return this.toPath((String)this.nodejsHomePath.getOrNull());
    }

    @Nullable
    private Path toPath(@Nullable String value) {
        return Optional.ofNullable(value).filter(v -> !v.trim().isEmpty()).map(x$0 -> Paths.get(x$0, new String[0])).orElse(null);
    }
}

