/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.IOException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.siouan.frontendgradleplugin.domain.exception.FrontendException;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.Environment;
import org.siouan.frontendgradleplugin.domain.model.InstallSettings;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.model.SystemSettingsProvider;
import org.siouan.frontendgradleplugin.domain.usecase.InstallNodeDistribution;
import org.siouan.frontendgradleplugin.domain.usecase.ResolveProxySettingsByUrl;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.Beans;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;

public abstract class AbstractDistributionInstallTask
extends DefaultTask {
    private final String beanRegistryId;
    private final Property<String> httpProxyHost;
    private final Property<Integer> httpProxyPort;
    private final Property<String> httpProxyUsername;
    private final Property<String> httpProxyPassword;
    private final Property<String> httpsProxyHost;
    private final Property<Integer> httpsProxyPort;
    private final Property<String> httpsProxyUsername;
    private final Property<String> httpsProxyPassword;

    protected AbstractDistributionInstallTask(@Nonnull ProjectLayout projectLayout, @Nonnull ObjectFactory objectFactory) {
        this.beanRegistryId = Beans.getBeanRegistryId(projectLayout.getProjectDirectory().toString());
        this.httpProxyHost = objectFactory.property(String.class);
        this.httpProxyPort = objectFactory.property(Integer.class);
        this.httpProxyUsername = objectFactory.property(String.class);
        this.httpProxyPassword = objectFactory.property(String.class);
        this.httpsProxyHost = objectFactory.property(String.class);
        this.httpsProxyPort = objectFactory.property(Integer.class);
        this.httpsProxyUsername = objectFactory.property(String.class);
        this.httpsProxyPassword = objectFactory.property(String.class);
    }

    @Internal
    public Property<String> getHttpProxyHost() {
        return this.httpProxyHost;
    }

    @Internal
    public Property<Integer> getHttpProxyPort() {
        return this.httpProxyPort;
    }

    @Internal
    public Property<String> getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    @Internal
    public Property<String> getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Internal
    public Property<String> getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    @Internal
    public Property<Integer> getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    @Internal
    public Property<String> getHttpsProxyUsername() {
        return this.httpsProxyUsername;
    }

    @Internal
    public Property<String> getHttpsProxyPassword() {
        return this.httpsProxyPassword;
    }

    @TaskAction
    public void execute() throws BeanRegistryException, FrontendException, IOException {
        Beans.getBean(this.beanRegistryId, TaskLoggerConfigurer.class).initLoggerAdapter((Task)this);
        Credentials distributionServerCredentials = this.getDistributionServerCredentials();
        Credentials httpProxyCredentials = (Credentials)this.httpProxyUsername.map(username -> new Credentials((String)username, (String)this.httpProxyPassword.get())).getOrNull();
        Credentials httpsProxyCredentials = (Credentials)this.httpsProxyUsername.map(username -> new Credentials((String)username, (String)this.httpsProxyPassword.get())).getOrNull();
        SystemSettingsProvider systemSettingsProvider = Beans.getBean(this.beanRegistryId, SystemSettingsProvider.class);
        Platform platform = new Platform(systemSettingsProvider.getSystemJvmArch(), systemSettingsProvider.getSystemOsName(), new Environment(systemSettingsProvider.getNodejsHomePath()));
        this.getLogger().debug("Platform: {}", (Object)platform);
        Beans.getBean(this.beanRegistryId, this.getInstallDistributionClass()).execute(this.getInstallSettings(platform, distributionServerCredentials, Beans.getBean(this.beanRegistryId, ResolveProxySettingsByUrl.class).execute((String)this.httpProxyHost.getOrNull(), (Integer)this.httpProxyPort.get(), httpProxyCredentials, (String)this.httpsProxyHost.getOrNull(), (Integer)this.httpsProxyPort.get(), httpsProxyCredentials, new URL(this.getDistributionUrlRoot()))));
    }

    @Internal
    @Nullable
    protected abstract Credentials getDistributionServerCredentials();

    @Internal
    @Nonnull
    protected abstract Class<? extends InstallNodeDistribution> getInstallDistributionClass();

    @Internal
    @Nonnull
    protected abstract String getDistributionUrlRoot();

    @Nonnull
    protected abstract InstallSettings getInstallSettings(@Nonnull Platform var1, @Nullable Credentials var2, @Nullable ProxySettings var3);
}

