/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.HttpClientException;
import org.siouan.frontendgradleplugin.domain.exception.ResourceDownloadException;
import org.siouan.frontendgradleplugin.domain.model.DownloadSettings;
import org.siouan.frontendgradleplugin.domain.model.HttpResponse;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.provider.ChannelProvider;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;
import org.siouan.frontendgradleplugin.domain.provider.HttpClientProvider;

public class DownloadResource {
    private final FileManager fileManager;
    private final ChannelProvider channelProvider;
    private final HttpClientProvider httpClientProvider;
    private final Logger logger;

    public DownloadResource(@Nonnull FileManager fileManager, @Nonnull ChannelProvider channelProvider, @Nonnull HttpClientProvider httpClientProvider, @Nonnull Logger logger) {
        this.fileManager = fileManager;
        this.channelProvider = channelProvider;
        this.httpClientProvider = httpClientProvider;
        this.logger = logger;
    }

    public void execute(@Nonnull DownloadSettings downloadSettings) throws IOException, ResourceDownloadException {
        URL resourceUrl = downloadSettings.getResourceUrl();
        ProxySettings proxySettings = downloadSettings.getProxySettings();
        if (proxySettings == null) {
            this.logger.info("Downloading resource at '{}' (proxy: DIRECT)", downloadSettings.getResourceUrl());
        } else {
            this.logger.info("Downloading resource at '{}' (proxy: {}/{}:{})", new Object[]{downloadSettings.getResourceUrl(), proxySettings.getProxyType(), proxySettings.getProxyHost(), proxySettings.getProxyPort()});
        }
        try (HttpResponse response = this.httpClientProvider.getInstance().sendGetRequest(resourceUrl, downloadSettings.getServerCredentials(), proxySettings);
             ReadableByteChannel resourceInputChannel = this.channelProvider.getReadableByteChannel(response.getInputStream());
             FileChannel resourceOutputChannel = this.channelProvider.getWritableFileChannelForNewFile(downloadSettings.getTemporaryFilePath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.logger.debug("---> {}/{} {} {}", response.getProtocol(), response.getVersion(), response.getStatusCode(), response.getReasonPhrase());
            if (response.getStatusCode() != 200) {
                throw new ResourceDownloadException("Unexpected HTTP response: " + response.getProtocol() + '/' + response.getVersion() + ' ' + response.getStatusCode() + ' ' + response.getReasonPhrase());
            }
            resourceOutputChannel.transferFrom(resourceInputChannel, 0L, Long.MAX_VALUE);
        }
        catch (HttpClientException e) {
            this.fileManager.deleteIfExists(downloadSettings.getTemporaryFilePath());
            throw new ResourceDownloadException(e);
        }
        catch (IOException | ResourceDownloadException e) {
            this.fileManager.deleteIfExists(downloadSettings.getTemporaryFilePath());
            throw e;
        }
        this.fileManager.move(downloadSettings.getTemporaryFilePath(), downloadSettings.getDestinationFilePath(), StandardCopyOption.REPLACE_EXISTING);
    }
}

