/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.siouan.frontendgradleplugin.domain.exception.HttpClientException;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.HttpClient;
import org.siouan.frontendgradleplugin.domain.model.HttpResponse;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.infrastructure.httpclient.LocalFileHttpResponse;

public abstract class AbstractHttpClient
implements HttpClient {
    @Override
    @Nonnull
    public HttpResponse sendGetRequest(@Nonnull URL resourceUrl, @Nullable Credentials credentials, @Nullable ProxySettings proxySettings) throws IOException, HttpClientException {
        if (resourceUrl.getProtocol().equals("file")) {
            return this.getLocalResource(resourceUrl);
        }
        return this.getRemoteResource(resourceUrl, credentials, proxySettings);
    }

    private HttpResponse getLocalResource(@Nonnull URL resourceUrl) {
        try {
            return new LocalFileHttpResponse(Paths.get(resourceUrl.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract HttpResponse getRemoteResource(@Nonnull URL var1, @Nullable Credentials var2, @Nullable ProxySettings var3) throws IOException, HttpClientException;
}

