/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.plugins.PublishingPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.siouan.frontendgradleplugin.infrastructure.Beans;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AssembleTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.CheckTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.CleanTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.EnableYarnBerryTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.FrontendExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.GradleSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallDependenciesTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.InstallYarnTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.NodeInstallTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.PublishTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.SystemExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.SystemSettingsProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;
import org.siouan.frontendgradleplugin.infrastructure.gradle.YarnGlobalInstallTask;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.GradleLoggerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.provider.ArchiverProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.provider.ChannelProviderImpl;
import org.siouan.frontendgradleplugin.infrastructure.provider.FileManagerImpl;
import org.siouan.frontendgradleplugin.infrastructure.provider.HttpClientProviderImpl;

public class FrontendGradlePlugin
implements Plugin<Project> {
    public static final String ASSEMBLE_TASK_NAME = "assembleFrontend";
    public static final String CHECK_TASK_NAME = "checkFrontend";
    public static final String CLEAN_TASK_NAME = "cleanFrontend";
    public static final String PUBLISH_TASK_NAME = "publishFrontend";
    public static final int DEFAULT_HTTP_PROXY_PORT = 80;
    public static final int DEFAULT_HTTPS_PROXY_PORT = 443;
    public static final String DEFAULT_NODE_INSTALL_DIRNAME = "node";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN = "vVERSION/node-vVERSION-ARCH.TYPE";
    public static final String DEFAULT_NODE_DISTRIBUTION_URL_ROOT = "https://nodejs.org/dist/";
    public static final String DEFAULT_YARN_GLOBAL_INSTALL_SCRIPT = "install -g yarn";
    public static final String DEFAULT_YARN_INSTALL_SCRIPT_PREFIX = "set version ";
    public static final String YARN_BERRY_VERSION = "berry";
    public static final String INSTALL_FRONTEND_TASK_NAME = "installFrontend";
    public static final String NODE_INSTALL_TASK_NAME = "installNode";
    public static final String NODEJS_HOME_ENV_VAR = "FGP_NODEJS_HOME";
    public static final String INSTALL_YARN_GLOBALLY_TASK_NAME = "installYarnGlobally";
    public static final String ENABLE_YARN_BERRY_TASK_NAME = "enableYarnBerry";
    public static final String YARN_INSTALL_TASK_NAME = "installYarn";
    public static final String GRADLE_CHECK_TASK_NAME = "check";
    private static final String DEFAULT_INSTALL_SCRIPT = "install";
    private static final String EXTENSION_NAME = "frontend";
    private static final String TASK_GROUP = "Frontend";

    public void apply(Project project) {
        project.getPluginManager().apply(BasePlugin.class);
        project.getPluginManager().apply(PublishingPlugin.class);
        SystemExtension systemExtension = new SystemExtension(project.getProviders());
        FrontendExtension extension = (FrontendExtension)project.getExtensions().create(EXTENSION_NAME, FrontendExtension.class, new Object[]{project.getObjects()});
        extension.getNodeDistributionProvided().convention((Object)false);
        extension.getNodeDistributionUrlRoot().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_ROOT);
        extension.getNodeDistributionUrlPathPattern().convention((Object)DEFAULT_NODE_DISTRIBUTION_URL_PATH_PATTERN);
        extension.getNodeInstallDirectory().convention(project.getLayout().getProjectDirectory().dir(DEFAULT_NODE_INSTALL_DIRNAME));
        extension.getYarnEnabled().convention((Object)false);
        extension.getYarnGlobalInstallScript().convention((Object)DEFAULT_YARN_GLOBAL_INSTALL_SCRIPT);
        extension.getYarnBerryEnableScript().convention((Object)"set version berry");
        extension.getYarnInstallScript().convention(extension.getYarnVersion().map(yarnVersion -> DEFAULT_YARN_INSTALL_SCRIPT_PREFIX + yarnVersion).orElse((Object)DEFAULT_YARN_INSTALL_SCRIPT_PREFIX));
        extension.getInstallScript().convention((Object)DEFAULT_INSTALL_SCRIPT);
        extension.getPackageJsonDirectory().convention((Object)project.getLayout().getProjectDirectory().getAsFile());
        extension.getHttpProxyPort().convention((Object)80);
        extension.getHttpsProxyPort().convention((Object)443);
        extension.getVerboseModeEnabled().convention((Object)false);
        SystemSettingsProviderImpl systemSettingsProvider = new SystemSettingsProviderImpl(systemExtension, 80, 443);
        GradleSettings gradleSettings = new GradleSettings(project.getLogging().getLevel(), project.getGradle().getStartParameter().getLogLevel());
        String beanRegistryId = Beans.getBeanRegistryId(project.getLayout().getProjectDirectory().toString());
        Beans.initBeanRegistry(beanRegistryId);
        Beans.registerBean(beanRegistryId, extension);
        Beans.registerBean(beanRegistryId, systemSettingsProvider);
        Beans.registerBean(beanRegistryId, gradleSettings);
        Beans.registerBean(beanRegistryId, GradleLoggerAdapter.class);
        Beans.registerBean(beanRegistryId, TaskLoggerConfigurer.class);
        Beans.registerBean(beanRegistryId, FileManagerImpl.class);
        Beans.registerBean(beanRegistryId, ChannelProviderImpl.class);
        Beans.registerBean(beanRegistryId, ArchiverProviderImpl.class);
        Beans.registerBean(beanRegistryId, HttpClientProviderImpl.class);
        TaskContainer taskContainer = project.getTasks();
        taskContainer.register(NODE_INSTALL_TASK_NAME, NodeInstallTask.class, task -> this.configureNodeInstallTask((NodeInstallTask)((Object)task), extension));
        taskContainer.register(INSTALL_YARN_GLOBALLY_TASK_NAME, YarnGlobalInstallTask.class, task -> this.configureYarnGlobalInstallTask(taskContainer, (YarnGlobalInstallTask)((Object)task), extension));
        taskContainer.register(ENABLE_YARN_BERRY_TASK_NAME, EnableYarnBerryTask.class, task -> this.configureYarnBerryEnablingTask(taskContainer, (EnableYarnBerryTask)((Object)task), extension));
        taskContainer.register(YARN_INSTALL_TASK_NAME, InstallYarnTask.class, task -> this.configureYarnInstallTask(taskContainer, (InstallYarnTask)((Object)task), extension));
        taskContainer.register(INSTALL_FRONTEND_TASK_NAME, InstallDependenciesTask.class, task -> this.configureInstallTask(taskContainer, (InstallDependenciesTask)((Object)task), extension));
        taskContainer.register(CLEAN_TASK_NAME, CleanTask.class, task -> this.configureCleanTask(taskContainer, (CleanTask)((Object)task), extension));
        taskContainer.register(CHECK_TASK_NAME, CheckTask.class, task -> this.configureCheckTask(taskContainer, (CheckTask)((Object)task), extension));
        taskContainer.register(ASSEMBLE_TASK_NAME, AssembleTask.class, task -> this.configureAssembleTask(taskContainer, (AssembleTask)((Object)task), extension));
        taskContainer.register(PUBLISH_TASK_NAME, PublishTask.class, task -> this.configurePublishTask(taskContainer, (PublishTask)((Object)task), extension));
        this.configureDependency(taskContainer, (Task)"clean", CLEAN_TASK_NAME, (Class)CleanTask.class);
        this.configureDependency(taskContainer, (Task)"assemble", ASSEMBLE_TASK_NAME, (Class)AssembleTask.class);
        this.configureDependency(taskContainer, (Task)GRADLE_CHECK_TASK_NAME, CHECK_TASK_NAME, (Class)CheckTask.class);
        this.configureDependency(taskContainer, (Task)"publish", PUBLISH_TASK_NAME, (Class)PublishTask.class);
        project.afterEvaluate(p -> this.finalizeExtension(extension));
    }

    private void finalizeExtension(@Nonnull FrontendExtension extension) {
        if (Boolean.TRUE.equals(extension.getNodeDistributionProvided().get())) {
            extension.getNodeInstallDirectory().convention((Directory)null);
        }
    }

    private void configureNodeInstallTask(NodeInstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Downloads and installs a Node distribution.");
        task.getNodeVersion().set(extension.getNodeVersion());
        task.getNodeDistributionUrlRoot().set(extension.getNodeDistributionUrlRoot());
        task.getNodeDistributionUrlPathPattern().set(extension.getNodeDistributionUrlPathPattern());
        task.getNodeDistributionServerUsername().set(extension.getNodeDistributionServerUsername());
        task.getNodeDistributionServerPassword().set(extension.getNodeDistributionServerPassword());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getHttpProxyHost().set(extension.getHttpProxyHost());
        task.getHttpProxyPort().set(extension.getHttpProxyPort());
        task.getHttpProxyUsername().set(extension.getHttpProxyUsername());
        task.getHttpProxyPassword().set(extension.getHttpProxyPassword());
        task.getHttpsProxyHost().set(extension.getHttpsProxyHost());
        task.getHttpsProxyPort().set(extension.getHttpsProxyPort());
        task.getHttpsProxyUsername().set(extension.getHttpsProxyUsername());
        task.getHttpsProxyPassword().set(extension.getHttpsProxyPassword());
        task.setOnlyIf(t -> (Boolean)extension.getNodeDistributionProvided().get() == false);
    }

    private void configureYarnGlobalInstallTask(TaskContainer taskContainer, YarnGlobalInstallTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs Yarn globally.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnGlobalInstallScript().set(extension.getYarnGlobalInstallScript());
        task.setOnlyIf(t -> (Boolean)extension.getYarnEnabled().get());
        this.configureDependency(taskContainer, task, NODE_INSTALL_TASK_NAME, NodeInstallTask.class);
    }

    private void configureYarnBerryEnablingTask(TaskContainer taskContainer, EnableYarnBerryTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Enables Yarn Berry.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getYarnBerryEnableScript().set(extension.getYarnBerryEnableScript());
        task.setOnlyIf(t -> (Boolean)extension.getYarnEnabled().get());
        this.configureDependency(taskContainer, task, INSTALL_YARN_GLOBALLY_TASK_NAME, YarnGlobalInstallTask.class);
    }

    private void configureYarnInstallTask(TaskContainer taskContainer, InstallYarnTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs the appropriate Yarn distribution in the project.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getYarnVersion().set(extension.getYarnVersion());
        task.getYarnInstallScript().set(extension.getYarnInstallScript());
        task.setOnlyIf(t -> (Boolean)extension.getYarnEnabled().get());
        this.configureDependency(taskContainer, task, ENABLE_YARN_BERRY_TASK_NAME, EnableYarnBerryTask.class);
    }

    private void configureInstallTask(TaskContainer taskContainer, InstallDependenciesTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Installs frontend dependencies.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getInstallScript().set(extension.getInstallScript());
        this.configureDependency(taskContainer, task, NODE_INSTALL_TASK_NAME, NodeInstallTask.class);
        this.configureDependency(taskContainer, task, YARN_INSTALL_TASK_NAME, InstallYarnTask.class);
    }

    private void configureCleanTask(TaskContainer taskContainer, CleanTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Cleans frontend resources outside the build directory by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getCleanScript().set(extension.getCleanScript());
        task.setOnlyIf(t -> extension.getCleanScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallDependenciesTask.class, (cleanTask, installDependenciesTask) -> cleanTask.getCleanScript().isPresent());
    }

    private void configureCheckTask(TaskContainer taskContainer, CheckTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Checks frontend by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getCheckScript().set(extension.getCheckScript());
        task.setOnlyIf(t -> extension.getCheckScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallDependenciesTask.class, (checkTask, installDependenciesTask) -> checkTask.getCheckScript().isPresent());
    }

    private void configureAssembleTask(TaskContainer taskContainer, AssembleTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Assembles frontend artifacts by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getAssembleScript().set(extension.getAssembleScript());
        task.setOnlyIf(t -> extension.getAssembleScript().isPresent());
        this.configureDependency(taskContainer, task, INSTALL_FRONTEND_TASK_NAME, InstallDependenciesTask.class, (assembleTask, installDependenciesTask) -> assembleTask.getAssembleScript().isPresent());
    }

    private void configurePublishTask(TaskContainer taskContainer, PublishTask task, FrontendExtension extension) {
        task.setGroup(TASK_GROUP);
        task.setDescription("Publishes frontend artifacts by running a specific script.");
        task.getPackageJsonDirectory().set(extension.getPackageJsonDirectory());
        task.getNodeInstallDirectory().set((Provider)extension.getNodeInstallDirectory());
        task.getYarnEnabled().set(extension.getYarnEnabled());
        task.getPublishScript().set(extension.getPublishScript());
        task.setOnlyIf(t -> extension.getAssembleScript().isPresent() && extension.getPublishScript().isPresent());
        this.configureDependency(taskContainer, task, ASSEMBLE_TASK_NAME, AssembleTask.class, (publishTask, assembleTask) -> publishTask.getPublishScript().isPresent());
    }

    private <D extends Task> void configureDependency(TaskContainer taskContainer, String taskName, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        taskContainer.named(taskName, Task.class, task -> this.configureDependency(taskContainer, task, dependsOnTaskName, dependsOnTaskClass));
    }

    private <T extends Task, D extends Task> void configureDependency(TaskContainer taskContainer, T task, String dependsOnTaskName, Class<D> dependsOnTaskClass) {
        this.configureDependency(taskContainer, task, dependsOnTaskName, dependsOnTaskClass, null);
    }

    private <T extends Task, D extends Task> void configureDependency(TaskContainer taskContainer, T task, String dependsOnTaskName, Class<D> dependsOnTaskClass, BiPredicate<T, D> condition) {
        TaskProvider dependsOnTask = taskContainer.named(dependsOnTaskName, dependsOnTaskClass);
        if (condition == null || this.canDependOn(task, dependsOnTask, condition)) {
            task.dependsOn(new Object[]{dependsOnTask.getName()});
        }
    }

    private <T extends Task, D extends Task> boolean canDependOn(T task, TaskProvider<D> dependsOnTaskProvider, BiPredicate<T, D> condition) {
        return dependsOnTaskProvider.isPresent() && condition.test(task, dependsOnTaskProvider.get());
    }
}

