/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.provider;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.Archiver;
import org.siouan.frontendgradleplugin.domain.provider.ArchiverProvider;
import org.siouan.frontendgradleplugin.domain.util.PathUtils;
import org.siouan.frontendgradleplugin.infrastructure.archiver.TarArchiver;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ZipArchiver;

public class ArchiverProviderImpl
implements ArchiverProvider {
    private final Map<String, Archiver> registeredArchivers = new HashMap<String, Archiver>();

    public ArchiverProviderImpl(TarArchiver tarArchiver, ZipArchiver zipArchiver) {
        this.registeredArchivers.put(".tar.gz", tarArchiver);
        this.registeredArchivers.put(".zip", zipArchiver);
    }

    @Override
    @Nonnull
    public Optional<Archiver> findByArchiveFilePath(@Nonnull Path archiveFilePath) {
        return PathUtils.getExtension(archiveFilePath).flatMap(extension -> {
            Optional<String> newExtension = PathUtils.isGzipExtension(extension) ? PathUtils.getExtension(PathUtils.removeExtension(archiveFilePath)).map(ext -> ext + extension) : Optional.of(extension);
            return newExtension;
        }).map(this.registeredArchivers::get);
    }
}

