/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.InstallSettings;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.usecase.InstallYarnDistribution;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AbstractDistributionInstallTask;

public class YarnInstallTask
extends AbstractDistributionInstallTask {
    private final Property<String> yarnVersion;
    private final DirectoryProperty yarnInstallDirectory;
    private final Property<String> yarnDistributionUrlRoot;
    private final Property<String> yarnDistributionUrlPathPattern;
    private final Property<String> yarnDistributionServerUsername;
    private final Property<String> yarnDistributionServerPassword;

    @Inject
    public YarnInstallTask(@Nonnull ProjectLayout projectLayout, @Nonnull ObjectFactory objectFactory) {
        super(projectLayout, objectFactory);
        this.yarnVersion = objectFactory.property(String.class);
        this.yarnInstallDirectory = objectFactory.directoryProperty();
        this.yarnDistributionUrlRoot = objectFactory.property(String.class);
        this.yarnDistributionUrlPathPattern = objectFactory.property(String.class);
        this.yarnDistributionServerUsername = objectFactory.property(String.class);
        this.yarnDistributionServerPassword = objectFactory.property(String.class);
    }

    @Input
    public Property<String> getYarnVersion() {
        return this.yarnVersion;
    }

    @Input
    public Property<String> getYarnDistributionUrlRoot() {
        return this.yarnDistributionUrlRoot;
    }

    @Input
    public Property<String> getYarnDistributionUrlPathPattern() {
        return this.yarnDistributionUrlPathPattern;
    }

    @Internal
    public Property<String> getYarnDistributionServerUsername() {
        return this.yarnDistributionServerUsername;
    }

    @Internal
    public Property<String> getYarnDistributionServerPassword() {
        return this.yarnDistributionServerPassword;
    }

    @OutputDirectory
    @Optional
    public DirectoryProperty getYarnInstallDirectory() {
        return this.yarnInstallDirectory;
    }

    @Override
    @Nullable
    protected Credentials getDistributionServerCredentials() {
        return (Credentials)this.yarnDistributionServerUsername.map(username -> new Credentials((String)this.yarnDistributionServerUsername.get(), (String)this.yarnDistributionServerPassword.get())).getOrNull();
    }

    @Nonnull
    protected Class<InstallYarnDistribution> getInstallDistributionClass() {
        return InstallYarnDistribution.class;
    }

    @Override
    @Nonnull
    protected String getDistributionUrlRoot() {
        return (String)this.yarnDistributionUrlRoot.get();
    }

    @Override
    @Nonnull
    protected InstallSettings getInstallSettings(@Nonnull Platform platform, @Nullable Credentials distributionServerCredentials, @Nullable ProxySettings proxySettings) {
        return new InstallSettings(platform, (String)this.yarnVersion.get(), (String)this.yarnDistributionUrlRoot.get(), (String)this.yarnDistributionUrlPathPattern.get(), distributionServerCredentials, proxySettings, this.getTemporaryDir().toPath(), ((File)this.yarnInstallDirectory.getAsFile().get()).toPath());
    }
}

