/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.InstallSettings;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.usecase.InstallNodeDistribution;
import org.siouan.frontendgradleplugin.infrastructure.gradle.AbstractDistributionInstallTask;

public class NodeInstallTask
extends AbstractDistributionInstallTask {
    private final Property<String> nodeVersion;
    private final DirectoryProperty nodeInstallDirectory;
    private final Property<String> nodeDistributionUrlRoot;
    private final Property<String> nodeDistributionUrlPathPattern;
    private final Property<String> nodeDistributionServerUsername;
    private final Property<String> nodeDistributionServerPassword;

    @Inject
    public NodeInstallTask(@Nonnull ProjectLayout projectLayout, @Nonnull ObjectFactory objectFactory) {
        super(projectLayout, objectFactory);
        this.nodeVersion = objectFactory.property(String.class);
        this.nodeInstallDirectory = objectFactory.directoryProperty();
        this.nodeDistributionUrlRoot = objectFactory.property(String.class);
        this.nodeDistributionUrlPathPattern = objectFactory.property(String.class);
        this.nodeDistributionServerUsername = objectFactory.property(String.class);
        this.nodeDistributionServerPassword = objectFactory.property(String.class);
    }

    @Input
    public Property<String> getNodeVersion() {
        return this.nodeVersion;
    }

    @Input
    public Property<String> getNodeDistributionUrlRoot() {
        return this.nodeDistributionUrlRoot;
    }

    @Input
    public Property<String> getNodeDistributionUrlPathPattern() {
        return this.nodeDistributionUrlPathPattern;
    }

    @OutputDirectory
    @Optional
    public DirectoryProperty getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @Internal
    public Property<String> getNodeDistributionServerUsername() {
        return this.nodeDistributionServerUsername;
    }

    @Internal
    public Property<String> getNodeDistributionServerPassword() {
        return this.nodeDistributionServerPassword;
    }

    @Override
    @Nullable
    protected Credentials getDistributionServerCredentials() {
        return (Credentials)this.nodeDistributionServerUsername.map(username -> new Credentials((String)this.nodeDistributionServerUsername.get(), (String)this.nodeDistributionServerPassword.get())).getOrNull();
    }

    @Nonnull
    protected Class<InstallNodeDistribution> getInstallDistributionClass() {
        return InstallNodeDistribution.class;
    }

    @Override
    @Nonnull
    protected String getDistributionUrlRoot() {
        return (String)this.nodeDistributionUrlRoot.get();
    }

    @Override
    @Nonnull
    protected InstallSettings getInstallSettings(@Nonnull Platform platform, @Nullable Credentials distributionServerCredentials, @Nullable ProxySettings proxySettings) {
        return new InstallSettings(platform, (String)this.nodeVersion.get(), (String)this.nodeDistributionUrlRoot.get(), (String)this.nodeDistributionUrlPathPattern.get(), distributionServerCredentials, proxySettings, this.getTemporaryDir().toPath(), ((File)this.nodeInstallDirectory.getAsFile().get()).toPath());
    }
}

