/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import java.io.File;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.ExecOperations;
import org.siouan.frontendgradleplugin.domain.exception.ExecutableNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.Environment;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.model.SystemSettingsProvider;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.Beans;
import org.siouan.frontendgradleplugin.infrastructure.gradle.FrontendExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.TaskLoggerConfigurer;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.GradleScriptRunnerAdapter;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.ScriptProperties;

public abstract class AbstractRunCommandTask
extends DefaultTask {
    final ExecOperations execOperations;
    final String beanRegistryId;
    final Property<File> packageJsonDirectory;
    final DirectoryProperty nodeInstallDirectory;
    final Property<Boolean> yarnEnabled;
    final DirectoryProperty yarnInstallDirectory;
    final Property<String> script;

    AbstractRunCommandTask(@Nonnull ProjectLayout projectLayout, @Nonnull ObjectFactory objectFactory, @Nonnull ExecOperations execOperations) {
        FrontendExtension extension;
        this.execOperations = execOperations;
        this.beanRegistryId = Beans.getBeanRegistryId(projectLayout.getProjectDirectory().toString());
        this.packageJsonDirectory = objectFactory.property(File.class);
        this.nodeInstallDirectory = objectFactory.directoryProperty();
        this.yarnEnabled = objectFactory.property(Boolean.class);
        this.yarnInstallDirectory = objectFactory.directoryProperty();
        this.script = objectFactory.property(String.class);
        try {
            extension = Beans.getBean(this.beanRegistryId, FrontendExtension.class);
        }
        catch (BeanRegistryException e) {
            throw new GradleException("Frontend plugin's bean registry failed", (Throwable)e);
        }
        this.packageJsonDirectory.set(extension.getPackageJsonDirectory());
        this.nodeInstallDirectory.set((Provider)extension.getNodeInstallDirectory());
        this.yarnEnabled.set(extension.getYarnEnabled());
        if (((Boolean)extension.getYarnEnabled().get()).booleanValue()) {
            this.yarnInstallDirectory.set((Provider)extension.getYarnInstallDirectory());
        }
    }

    @Input
    @Optional
    public Property<File> getPackageJsonDirectory() {
        return this.packageJsonDirectory;
    }

    @Internal
    public DirectoryProperty getNodeInstallDirectory() {
        return this.nodeInstallDirectory;
    }

    @Internal
    public DirectoryProperty getYarnInstallDirectory() {
        return this.yarnInstallDirectory;
    }

    @Internal
    protected abstract String getExecutableType();

    @TaskAction
    public void execute() throws ExecutableNotFoundException, BeanRegistryException {
        if (this.script.isPresent()) {
            Beans.getBean(this.beanRegistryId, TaskLoggerConfigurer.class).initLoggerAdapter((Task)this);
            SystemSettingsProvider systemSettingsProvider = Beans.getBean(this.beanRegistryId, SystemSettingsProvider.class);
            Platform platform = new Platform(systemSettingsProvider.getSystemJvmArch(), systemSettingsProvider.getSystemOsName(), new Environment(systemSettingsProvider.getNodejsHomePath(), systemSettingsProvider.getYarnHomePath()));
            this.getLogger().debug("Platform: {}", (Object)platform);
            Beans.getBean(this.beanRegistryId, GradleScriptRunnerAdapter.class).execute(new ScriptProperties(this.execOperations, (Path)this.packageJsonDirectory.map(File::toPath).get(), this.getExecutableType(), (Path)this.nodeInstallDirectory.getAsFile().map(File::toPath).getOrNull(), (Path)this.yarnInstallDirectory.getAsFile().map(File::toPath).getOrNull(), (String)this.script.get(), platform));
        }
    }
}

