/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.infrastructure.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.ZeroOrMultiplePublicConstructorsException;

public final class Beans {
    private static final Beans INSTANCE = new Beans();
    private final Map<String, BeanRegistry> beanRegistryByIds = new ConcurrentHashMap<String, BeanRegistry>();

    private Beans() {
    }

    public static void initBeanRegistry(String registryId) {
        Optional<BeanRegistry> beanRegistry = INSTANCE.findBeanRegistryById(registryId);
        if (beanRegistry.isPresent()) {
            beanRegistry.get().init();
        } else {
            INSTANCE.addBeanRegistry(registryId, new BeanRegistry());
        }
    }

    public static String getBeanRegistryId(@Nonnull String decodedId) {
        return Base64.getEncoder().encodeToString(decodedId.getBytes(StandardCharsets.UTF_8));
    }

    public static <T> T getBean(@Nonnull String registryId, @Nonnull Class<T> beanClass) throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException {
        return INSTANCE.findBeanRegistryByIdOrFail(registryId).getBean(beanClass);
    }

    public static <T> void registerBean(@Nonnull String registryId, @Nonnull Class<T> beanClass) {
        INSTANCE.findBeanRegistryByIdOrFail(registryId).registerBean(beanClass);
    }

    public static <T> void registerBean(@Nonnull String registryId, @Nonnull T bean) {
        INSTANCE.findBeanRegistryByIdOrFail(registryId).registerBean(bean);
    }

    public void addBeanRegistry(@Nonnull String registryId, @Nonnull BeanRegistry beanRegistry) {
        this.beanRegistryByIds.put(registryId, beanRegistry);
    }

    @Nonnull
    public BeanRegistry findBeanRegistryByIdOrFail(@Nonnull String registryId) {
        return this.findBeanRegistryById(registryId).orElseThrow(() -> new IllegalArgumentException("No registry was found with ID " + registryId));
    }

    @Nonnull
    public Optional<BeanRegistry> findBeanRegistryById(@Nonnull String registryId) {
        return Optional.ofNullable(this.beanRegistryByIds.get(registryId));
    }
}

