/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedPlatformException;
import org.siouan.frontendgradleplugin.domain.model.DistributionDefinition;
import org.siouan.frontendgradleplugin.domain.model.DistributionUrlResolver;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.usecase.ResolveNodeDistributionArchitectureId;
import org.siouan.frontendgradleplugin.domain.usecase.ResolveNodeDistributionType;

public class ResolveNodeDistributionUrl
implements DistributionUrlResolver {
    public static final String VERSION_TOKEN = "VERSION";
    public static final String ARCHITECTURE_ID_TOKEN = "ARCH";
    public static final String TYPE_TOKEN = "TYPE";
    private final ResolveNodeDistributionArchitectureId resolveNodeDistributionArchitectureId;
    private final ResolveNodeDistributionType resolveNodeDistributionType;

    public ResolveNodeDistributionUrl(@Nonnull ResolveNodeDistributionArchitectureId resolveNodeDistributionArchitectureId, @Nonnull ResolveNodeDistributionType resolveNodeDistributionType) {
        this.resolveNodeDistributionArchitectureId = resolveNodeDistributionArchitectureId;
        this.resolveNodeDistributionType = resolveNodeDistributionType;
    }

    @Override
    @Nonnull
    public URL execute(@Nonnull DistributionDefinition distributionDefinition) throws UnsupportedPlatformException, MalformedURLException {
        Platform platform = distributionDefinition.getPlatform();
        String pathPatternWithVersionResolved = distributionDefinition.getDownloadUrlPathPattern().replace(VERSION_TOKEN, distributionDefinition.getVersion());
        String pathPatternWithArchIdResolved = pathPatternWithVersionResolved.contains(ARCHITECTURE_ID_TOKEN) ? pathPatternWithVersionResolved.replace(ARCHITECTURE_ID_TOKEN, this.resolveNodeDistributionArchitectureId.execute(platform).orElseThrow(() -> new UnsupportedPlatformException(distributionDefinition.getPlatform()))) : pathPatternWithVersionResolved;
        String pathPatternWithTypeResolved = pathPatternWithArchIdResolved.contains(TYPE_TOKEN) ? pathPatternWithArchIdResolved.replace(TYPE_TOKEN, this.resolveNodeDistributionType.execute(platform)) : pathPatternWithArchIdResolved;
        return new URL(distributionDefinition.getDownloadUrlRoot() + pathPatternWithTypeResolved);
    }
}

