/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.siouan.frontendgradleplugin.domain.exception.ExecutableNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.usecase.GetNodeExecutablePath;
import org.siouan.frontendgradleplugin.domain.usecase.GetNpmExecutablePath;
import org.siouan.frontendgradleplugin.domain.usecase.GetNpxExecutablePath;
import org.siouan.frontendgradleplugin.domain.usecase.GetYarnExecutablePath;

public class ResolveExecutablePath {
    private final GetNodeExecutablePath getNodeExecutablePath;
    private final GetNpmExecutablePath getNpmExecutablePath;
    private final GetNpxExecutablePath getNpxExecutablePath;
    private final GetYarnExecutablePath getYarnExecutablePath;

    public ResolveExecutablePath(GetNodeExecutablePath getNodeExecutablePath, GetNpmExecutablePath getNpmExecutablePath, GetNpxExecutablePath getNpxExecutablePath, GetYarnExecutablePath getYarnExecutablePath) {
        this.getNodeExecutablePath = getNodeExecutablePath;
        this.getNpmExecutablePath = getNpmExecutablePath;
        this.getNpxExecutablePath = getNpxExecutablePath;
        this.getYarnExecutablePath = getYarnExecutablePath;
    }

    @Nonnull
    public Path execute(@Nonnull String executableType, @Nullable Path nodeInstallDirectoryPath, @Nullable Path yarnInstallDirectoryPath, @Nonnull Platform platform) throws ExecutableNotFoundException {
        switch (executableType) {
            case "node": {
                return this.getNodeExecutablePath.execute(nodeInstallDirectoryPath, platform);
            }
            case "npm": {
                return this.getNpmExecutablePath.execute(nodeInstallDirectoryPath, platform);
            }
            case "npx": {
                return this.getNpxExecutablePath.execute(nodeInstallDirectoryPath, platform);
            }
            case "yarn": {
                return this.getYarnExecutablePath.execute(yarnInstallDirectoryPath, platform);
            }
        }
        throw new IllegalArgumentException("Unsupported type of execution: " + executableType);
    }
}

