/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.util.Optional;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.model.DistributionValidator;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;
import org.siouan.frontendgradleplugin.domain.usecase.BuildTemporaryFileName;
import org.siouan.frontendgradleplugin.domain.usecase.DownloadResource;
import org.siouan.frontendgradleplugin.domain.usecase.HashFile;
import org.siouan.frontendgradleplugin.domain.usecase.ReadNodeDistributionShasum;
import org.siouan.frontendgradleplugin.domain.usecase.ValidateNodeDistribution;

public class GetDistributionValidator {
    private final FileManager fileManager;
    private final BuildTemporaryFileName buildTemporaryFileName;
    private final DownloadResource downloadResource;
    private final ReadNodeDistributionShasum readNodeDistributionShasum;
    private final HashFile hashFile;
    private final Logger logger;

    public GetDistributionValidator(FileManager fileManager, BuildTemporaryFileName buildTemporaryFileName, DownloadResource downloadResource, ReadNodeDistributionShasum readNodeDistributionShasum, HashFile hashFile, Logger logger) {
        this.fileManager = fileManager;
        this.buildTemporaryFileName = buildTemporaryFileName;
        this.downloadResource = downloadResource;
        this.readNodeDistributionShasum = readNodeDistributionShasum;
        this.hashFile = hashFile;
        this.logger = logger;
    }

    @Nonnull
    public Optional<DistributionValidator> execute(@Nonnull String distributionId) {
        switch (distributionId) {
            case "NODE": {
                return Optional.of(new ValidateNodeDistribution(this.fileManager, this.buildTemporaryFileName, this.downloadResource, this.readNodeDistributionShasum, this.hashFile, this.logger));
            }
        }
        return Optional.empty();
    }
}

