/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.siouan.frontendgradleplugin.domain.exception.ExecutableNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.model.Platform;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;

public abstract class AbstractGetExecutablePath {
    private final FileManager fileManager;
    private final Logger logger;

    protected AbstractGetExecutablePath(FileManager fileManager, Logger logger) {
        this.fileManager = fileManager;
        this.logger = logger;
    }

    @Nonnull
    public Path execute(@Nullable Path installDirectory, @Nonnull Platform platform) throws ExecutableNotFoundException {
        Optional<Path> resolvedInstallDirectory;
        if (installDirectory == null) {
            resolvedInstallDirectory = this.getInstallDirectoryFromEnvironment(platform);
            this.logger.info("Install directory resolved from environment variable: {}", resolvedInstallDirectory);
        } else {
            this.logger.info("Install directory resolved from extension: {}", installDirectory);
            resolvedInstallDirectory = Optional.of(installDirectory);
        }
        Path relativeExecutablePath = platform.isWindowsOs() ? this.getWindowsRelativeExecutablePath() : this.getNonWindowsRelativeExecutablePath();
        if (resolvedInstallDirectory.isPresent()) {
            Path executablePath = resolvedInstallDirectory.get().resolve(relativeExecutablePath);
            if (this.fileManager.exists(executablePath)) {
                this.logger.info("Executable '{}' resolved from install directory", executablePath);
                return executablePath;
            }
            throw new ExecutableNotFoundException(executablePath);
        }
        Path executablePath = this.getExecutableFileName(platform);
        this.logger.info("Executable '{}' resolved from PATH environment variable", executablePath);
        return executablePath;
    }

    @Nonnull
    private Path getExecutableFileName(@Nonnull Platform platform) {
        return platform.isWindowsOs() ? this.getWindowsExecutableFileName() : this.getNonWindowsExecutableFileName();
    }

    @Nonnull
    protected abstract Path getWindowsRelativeExecutablePath();

    @Nonnull
    protected abstract Path getNonWindowsRelativeExecutablePath();

    @Nonnull
    protected abstract Path getWindowsExecutableFileName();

    @Nonnull
    protected abstract Path getNonWindowsExecutableFileName();

    @Nonnull
    protected abstract Optional<Path> getInstallDirectoryFromEnvironment(@Nonnull Platform var1);
}

