/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.model;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class ExecutionSettings {
    private final Path workingDirectoryPath;
    private final Set<Path> additionalExecutablePaths;
    private final Path executablePath;
    private final List<String> arguments;

    public ExecutionSettings(@Nonnull Path workingDirectoryPath, @Nonnull Set<Path> additionalExecutablePaths, @Nonnull Path executablePath, @Nonnull List<String> arguments) {
        this.workingDirectoryPath = workingDirectoryPath;
        this.additionalExecutablePaths = Collections.unmodifiableSet(additionalExecutablePaths);
        this.executablePath = executablePath;
        this.arguments = Collections.unmodifiableList(arguments);
    }

    @Nonnull
    public Path getWorkingDirectoryPath() {
        return this.workingDirectoryPath;
    }

    @Nonnull
    public Set<Path> getAdditionalExecutablePaths() {
        return this.additionalExecutablePaths;
    }

    @Nonnull
    public Path getExecutablePath() {
        return this.executablePath;
    }

    @Nonnull
    public List<String> getArguments() {
        return this.arguments;
    }

    public String toString() {
        return ExecutionSettings.class.getSimpleName() + " {workingDirectoryPath=" + this.workingDirectoryPath + ", executablePaths=[" + this.additionalExecutablePaths.stream().map(Path::toString).collect(Collectors.joining(", ")) + "], executable=" + this.executablePath + ", arguments=[" + String.join((CharSequence)", ", this.arguments) + "]}";
    }
}

