/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle.adapter;

import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.process.ExecSpec;
import org.siouan.frontendgradleplugin.domain.exception.ExecutableNotFoundException;
import org.siouan.frontendgradleplugin.domain.model.ExecutionSettings;
import org.siouan.frontendgradleplugin.domain.model.Logger;
import org.siouan.frontendgradleplugin.domain.usecase.ResolveExecutionSettings;
import org.siouan.frontendgradleplugin.infrastructure.gradle.ExecSpecAction;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.ScriptProperties;

public class GradleScriptRunnerAdapter {
    private final ResolveExecutionSettings resolveExecutionSettings;
    private final Logger logger;

    public GradleScriptRunnerAdapter(ResolveExecutionSettings resolveExecutionSettings, Logger logger) {
        this.resolveExecutionSettings = resolveExecutionSettings;
        this.logger = logger;
    }

    public void execute(@Nonnull ScriptProperties scriptProperties) throws ExecutableNotFoundException {
        ExecutionSettings executionSettings = this.resolveExecutionSettings.execute(scriptProperties.getPackageJsonDirectoryPath(), scriptProperties.getExecutableType(), scriptProperties.getNodeInstallDirectory(), scriptProperties.getYarnInstallDirectory(), scriptProperties.getPlatform(), scriptProperties.getScript());
        this.logger.debug("Execution settings: {}", executionSettings);
        scriptProperties.getProject().exec((Action)new ExecSpecAction(executionSettings, this::logExecSpecBeforeExecution)).rethrowFailure().assertNormalExitValue();
    }

    private void logExecSpecBeforeExecution(@Nonnull ExecSpec execSpec) {
        this.logger.debug("Execution environment: {}", execSpec.getEnvironment());
        this.logger.info("Running '{}' with arguments: [{}]", execSpec.getExecutable(), String.join((CharSequence)"], [", execSpec.getArgs()));
    }
}

