/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedPlatformException;
import org.siouan.frontendgradleplugin.domain.model.DistributionDefinition;
import org.siouan.frontendgradleplugin.domain.model.DistributionUrlResolver;
import org.siouan.frontendgradleplugin.domain.model.Platform;

public class ResolveNodeDistributionUrl
implements DistributionUrlResolver {
    public static final String VERSION_TOKEN = "VERSION";
    public static final String ARCHITECTURE_ID_TOKEN = "ARCH";
    public static final String TYPE_TOKEN = "TYPE";
    private static final String TAR_GZ_TYPE = "tar.gz";
    private static final String ZIP_TYPE = "zip";
    private static final String LINUX_64_ARCH = "linux-x64";
    private static final String MACOS_64_ARCH = "darwin-x64";
    private static final String WINDOWS_32_ARCH = "win-x86";
    private static final String WINDOWS_64_ARCH = "win-x64";

    @Override
    @Nonnull
    public URL execute(@Nonnull DistributionDefinition distributionDefinition) throws UnsupportedPlatformException, MalformedURLException {
        Platform platform = distributionDefinition.getPlatform();
        Optional<String> architectureId = this.resolveArchitectureId(platform);
        if (!architectureId.isPresent()) {
            throw new UnsupportedPlatformException(distributionDefinition.getPlatform());
        }
        return new URL(distributionDefinition.getDownloadUrlRoot() + distributionDefinition.getDownloadUrlPathPattern().replace(VERSION_TOKEN, distributionDefinition.getVersion()).replace(ARCHITECTURE_ID_TOKEN, architectureId.get()).replace(TYPE_TOKEN, this.resolveType(platform)));
    }

    @Nonnull
    private Optional<String> resolveArchitectureId(@Nonnull Platform platform) {
        String extension = platform.is64BitsArch() ? (platform.isWindowsOs() ? WINDOWS_64_ARCH : (platform.isLinuxOs() ? LINUX_64_ARCH : (platform.isMacOs() ? MACOS_64_ARCH : null))) : (platform.isWindowsOs() ? WINDOWS_32_ARCH : null);
        return Optional.ofNullable(extension);
    }

    @Nonnull
    private String resolveType(@Nonnull Platform platform) {
        return platform.isWindowsOs() ? ZIP_TYPE : TAR_GZ_TYPE;
    }
}

