/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.httpclient;

import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.siouan.frontendgradleplugin.domain.exception.HttpClientException;
import org.siouan.frontendgradleplugin.domain.model.Credentials;
import org.siouan.frontendgradleplugin.domain.model.HttpResponse;
import org.siouan.frontendgradleplugin.domain.model.ProxySettings;
import org.siouan.frontendgradleplugin.domain.usecase.AbstractHttpClient;
import org.siouan.frontendgradleplugin.infrastructure.httpclient.ApacheHttpResponse;

public class ApacheHttpClient
extends AbstractHttpClient {
    @Override
    @Nonnull
    protected HttpResponse getRemoteResource(@Nonnull URL resourceUrl, @Nullable Credentials credentials, @Nullable ProxySettings proxySettings) throws IOException, HttpClientException {
        BasicScheme basicScheme = new BasicScheme();
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        BasicAuthCache authCache = new BasicAuthCache();
        HttpClientContext httpClientContext = HttpClientContext.create();
        httpClientContext.setAuthCache((AuthCache)authCache);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (credentials != null) {
            HttpHost serverHost = new HttpHost(resourceUrl.getHost(), resourceUrl.getPort());
            try {
                basicScheme.processChallenge((Header)new BasicHeader("WWW-Authenticate", this.buildAuthorization(credentials)));
            }
            catch (MalformedChallengeException e) {
                throw new HttpClientException(e);
            }
            authCache.put(serverHost, (AuthScheme)basicScheme);
            this.registerCredentials((CredentialsProvider)credentialsProvider, serverHost, credentials.getUsername(), credentials.getPassword());
        }
        if (proxySettings != null) {
            HttpHost proxyServerHost = new HttpHost(proxySettings.getProxyHost(), proxySettings.getProxyPort());
            Credentials proxyCredentials = proxySettings.getCredentials();
            if (proxyCredentials != null) {
                try {
                    basicScheme.processChallenge((Header)new BasicHeader("Proxy-Authenticate", this.buildAuthorization(proxyCredentials)));
                }
                catch (MalformedChallengeException e) {
                    throw new HttpClientException(e);
                }
                authCache.put(proxyServerHost, (AuthScheme)basicScheme);
                this.registerCredentials((CredentialsProvider)credentialsProvider, proxyServerHost, proxyCredentials.getUsername(), proxyCredentials.getPassword());
            }
            requestConfigBuilder.setProxy(proxyServerHost);
        }
        HttpGet httpGet = new HttpGet(resourceUrl.toString());
        httpGet.setConfig(requestConfigBuilder.build());
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        try {
            return new ApacheHttpResponse(httpClient, httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpClientContext));
        }
        catch (IOException e) {
            httpClient.close();
            throw e;
        }
    }

    private void registerCredentials(@Nonnull CredentialsProvider credentialsProvider, @Nonnull HttpHost host, @Nonnull String username, @Nonnull String password) {
        credentialsProvider.setCredentials(new AuthScope(host), (org.apache.http.auth.Credentials)new UsernamePasswordCredentials(username, password));
    }

    private String buildAuthorization(@Nonnull Credentials credentials) {
        String basicCredentials = credentials.getUsername() + ':' + credentials.getPassword();
        return "Basic " + Base64.getEncoder().encodeToString(basicCredentials.getBytes());
    }
}

