/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.archiver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.siouan.frontendgradleplugin.domain.model.ExplodeSettings;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;
import org.siouan.frontendgradleplugin.domain.usecase.AbstractArchiver;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ZipArchiverContext;
import org.siouan.frontendgradleplugin.infrastructure.archiver.ZipEntry;

public class ZipArchiver
extends AbstractArchiver<ZipArchiverContext, ZipEntry> {
    public ZipArchiver(FileManager fileManager) {
        super(fileManager);
    }

    @Override
    @Nonnull
    protected ZipArchiverContext initializeContext(@Nonnull ExplodeSettings settings) throws IOException {
        return new ZipArchiverContext(settings, new ZipFile(settings.getArchiveFilePath().toFile()));
    }

    @Override
    @Nonnull
    protected Optional<ZipEntry> getNextEntry(@Nonnull ZipArchiverContext context) {
        return Optional.ofNullable(context.getEntries().hasMoreElements() ? context.getEntries().nextElement() : null).map(ZipEntry::new);
    }

    @Override
    @Nonnull
    protected String getSymbolicLinkTarget(@Nonnull ZipArchiverContext context, @Nonnull ZipEntry entry) throws IOException {
        return this.readSymbolicLinkTarget(context.getZipFile(), entry.getLowLevelEntry());
    }

    @Override
    protected void writeRegularFile(@Nonnull ZipArchiverContext context, @Nonnull ZipEntry entry, @Nonnull Path filePath) throws IOException {
        try (InputStream entryInputStream = context.getZipFile().getInputStream(entry.getLowLevelEntry());){
            this.fileManager.copy(entryInputStream, filePath);
        }
    }

    String readSymbolicLinkTarget(ZipFile zipFile, ZipArchiveEntry entry) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));){
            String string = reader.readLine();
            return string;
        }
    }
}

