/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.siouan.frontendgradleplugin.infrastructure.BeanInstanciationException;
import org.siouan.frontendgradleplugin.infrastructure.TooManyCandidateBeansException;
import org.siouan.frontendgradleplugin.infrastructure.ZeroOrMultiplePublicConstructorsException;

public class BeanRegistry {
    private final Map<Class<?>, Object> singletons = new HashMap();

    public BeanRegistry() {
        this.init();
    }

    public void init() {
        this.singletons.clear();
        this.registerBean(BeanRegistry.class, this);
    }

    @Nonnull
    public <T> T getBean(@Nonnull Class<T> beanClass) throws BeanInstanciationException, TooManyCandidateBeansException, ZeroOrMultiplePublicConstructorsException {
        Object existingBean = this.singletons.get(beanClass);
        if (existingBean != null) {
            return (T)existingBean;
        }
        Class assignableClass = this.getAssignableClass(beanClass);
        if (assignableClass != null) {
            return (T)this.getBean(assignableClass);
        }
        this.assertBeanClassIsInstanciable(beanClass);
        T newBean = this.createInstance(beanClass);
        this.registerBean(beanClass, newBean);
        return newBean;
    }

    public <T> void registerBean(@Nonnull Class<T> beanClass) {
        if (this.isBeanRegistered(beanClass)) {
            return;
        }
        this.assertBeanClassIsInstanciable(beanClass);
        this.registerBean(beanClass, null);
    }

    public <T> void registerBean(@Nonnull T bean) {
        Class<?> beanClass = bean.getClass();
        if (this.isBeanRegistered(beanClass)) {
            return;
        }
        this.registerBean(beanClass, bean);
    }

    private <T> void registerBean(@Nonnull Class<T> beanClass, @Nullable T bean) {
        this.singletons.put(beanClass, bean);
    }

    private <T> boolean isBeanRegistered(@Nonnull Class<T> beanClass) {
        return this.getClass().isAssignableFrom(beanClass) || this.singletons.containsKey(beanClass);
    }

    private void assertBeanClassIsInstanciable(@Nonnull Class<?> beanClass) {
        if (beanClass.isInterface() || beanClass.isEnum() || (beanClass.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException("An interface, an enumeration, or an abstract class can not be registered or instanciated: " + beanClass.getName());
        }
    }

    @Nullable
    private <T, C extends T> Class<C> getAssignableClass(@Nonnull Class<T> beanClass) throws TooManyCandidateBeansException {
        Set assignableBeanClasses = this.singletons.keySet().stream().filter(clazz -> !clazz.equals(beanClass)).filter(beanClass::isAssignableFrom).map(clazz -> clazz).collect(Collectors.toSet());
        if (assignableBeanClasses.isEmpty()) {
            return null;
        }
        if (assignableBeanClasses.size() > 1) {
            throw new TooManyCandidateBeansException(beanClass, assignableBeanClasses);
        }
        return (Class)assignableBeanClasses.iterator().next();
    }

    private <T> T createInstance(@Nonnull Class<T> beanClass) throws BeanInstanciationException, ZeroOrMultiplePublicConstructorsException, TooManyCandidateBeansException {
        Constructor<?>[] constructors = beanClass.getConstructors();
        if (constructors.length != 1) {
            throw new ZeroOrMultiplePublicConstructorsException(beanClass);
        }
        Class<?>[] parameterTypes = constructors[0].getParameterTypes();
        Object[] parameters = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters[i] = this.getBean(parameterTypes[i]);
        }
        try {
            return (T)beanClass.getConstructors()[0].newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new BeanInstanciationException(beanClass, (Throwable)e);
        }
    }
}

