/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.domain.usecase;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.siouan.frontendgradleplugin.domain.exception.ArchiverException;
import org.siouan.frontendgradleplugin.domain.exception.DirectoryNotFoundException;
import org.siouan.frontendgradleplugin.domain.exception.InvalidRelativizedSymbolicLinkTargetException;
import org.siouan.frontendgradleplugin.domain.exception.SlipAttackException;
import org.siouan.frontendgradleplugin.domain.exception.UnsupportedEntryException;
import org.siouan.frontendgradleplugin.domain.model.ArchiveEntry;
import org.siouan.frontendgradleplugin.domain.model.Archiver;
import org.siouan.frontendgradleplugin.domain.model.ArchiverContext;
import org.siouan.frontendgradleplugin.domain.model.ExplodeSettings;
import org.siouan.frontendgradleplugin.domain.provider.FileManager;

public abstract class AbstractArchiver<C extends ArchiverContext, E extends ArchiveEntry>
implements Archiver {
    private static final Map<Integer, PosixFilePermission> UNIX_MASK_TO_PERMISSION = new HashMap<Integer, PosixFilePermission>();
    protected final FileManager fileManager;

    protected AbstractArchiver(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    @Nonnull
    protected abstract C initializeContext(@Nonnull ExplodeSettings var1) throws ArchiverException, IOException;

    @Nonnull
    protected abstract Optional<E> getNextEntry(@Nonnull C var1) throws IOException;

    @Nonnull
    protected abstract String getSymbolicLinkTarget(@Nonnull C var1, @Nonnull E var2) throws IOException;

    @Override
    public void explode(@Nonnull ExplodeSettings settings) throws ArchiverException, IOException {
        Path targetDirectoryPath = settings.getTargetDirectoryPath();
        if (!this.fileManager.isDirectory(targetDirectoryPath)) {
            throw new DirectoryNotFoundException(targetDirectoryPath);
        }
        try (C context = this.initializeContext(settings);){
            Optional<E> entry = this.getNextEntry(context);
            while (entry.isPresent()) {
                this.extractEntry(context, (ArchiveEntry)entry.get());
                entry = this.getNextEntry(context);
            }
        }
    }

    private void extractEntry(@Nonnull C context, @Nonnull E entry) throws ArchiverException, IOException {
        Path targetFilePath = context.getSettings().getTargetDirectoryPath().resolve(entry.getName());
        if (!targetFilePath.normalize().startsWith(context.getSettings().getTargetDirectoryPath().normalize())) {
            throw new SlipAttackException(entry.getName());
        }
        if (!this.fileManager.isDirectory(targetFilePath.getParent())) {
            this.fileManager.createDirectories(targetFilePath.getParent());
        }
        if (entry.isSymbolicLink()) {
            this.writeSymbolicLink(context, entry, targetFilePath);
        } else if (entry.isDirectory()) {
            this.writeDirectory(targetFilePath);
        } else if (entry.isFile()) {
            this.writeRegularFile(context, entry, targetFilePath);
        } else {
            throw new UnsupportedEntryException(entry.getName());
        }
        if (!entry.isSymbolicLink() && !context.getSettings().getPlatform().isWindowsOs()) {
            this.fileManager.setPosixFilePermissions(targetFilePath, this.toPosixPermissions(entry.getUnixMode()));
        }
    }

    private void writeSymbolicLink(@Nonnull C context, @Nonnull E entry, @Nonnull Path linkFilePath) throws IOException, ArchiverException {
        Path targetFilePath = linkFilePath.getParent().resolve(this.getSymbolicLinkTarget(context, entry));
        Path normalizedAndRelativizedTargetFilePath = linkFilePath.getParent().relativize(targetFilePath.normalize());
        this.fileManager.createSymbolicLink(linkFilePath, normalizedAndRelativizedTargetFilePath);
        Path relativizedTargetFilePath = linkFilePath.getParent().relativize(targetFilePath);
        if (!this.fileManager.isSameFile(relativizedTargetFilePath, normalizedAndRelativizedTargetFilePath) && (this.fileManager.exists(relativizedTargetFilePath) || this.fileManager.exists(normalizedAndRelativizedTargetFilePath))) {
            throw new InvalidRelativizedSymbolicLinkTargetException(entry.getName(), targetFilePath);
        }
    }

    private void writeDirectory(@Nonnull Path directoryPath) throws IOException {
        this.fileManager.createDirectory(directoryPath);
    }

    protected abstract void writeRegularFile(@Nonnull C var1, @Nonnull E var2, @Nonnull Path var3) throws IOException;

    @Nonnull
    private Set<PosixFilePermission> toPosixPermissions(int unixMode) {
        return UNIX_MASK_TO_PERMISSION.entrySet().stream().filter(entry -> ((Integer)entry.getKey() & unixMode) != 0).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    static {
        UNIX_MASK_TO_PERMISSION.put(256, PosixFilePermission.OWNER_READ);
        UNIX_MASK_TO_PERMISSION.put(128, PosixFilePermission.OWNER_WRITE);
        UNIX_MASK_TO_PERMISSION.put(64, PosixFilePermission.OWNER_EXECUTE);
        UNIX_MASK_TO_PERMISSION.put(32, PosixFilePermission.GROUP_READ);
        UNIX_MASK_TO_PERMISSION.put(16, PosixFilePermission.GROUP_WRITE);
        UNIX_MASK_TO_PERMISSION.put(8, PosixFilePermission.GROUP_EXECUTE);
        UNIX_MASK_TO_PERMISSION.put(4, PosixFilePermission.OTHERS_READ);
        UNIX_MASK_TO_PERMISSION.put(2, PosixFilePermission.OTHERS_WRITE);
        UNIX_MASK_TO_PERMISSION.put(1, PosixFilePermission.OTHERS_EXECUTE);
    }
}

