/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle.adapter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;

public class GradleLoggerAdapter
implements org.siouan.frontendgradleplugin.domain.model.Logger {
    private Logger gradleLogger;
    private LogLevel loggingLevel = LogLevel.LIFECYCLE;
    private boolean verboseModeEnabled = false;
    private String prefix;

    public void init(@Nullable Logger gradleLogger, @Nonnull LogLevel loggingLevel, boolean verboseModeEnabled, @Nullable String prefix) {
        this.gradleLogger = gradleLogger;
        this.loggingLevel = loggingLevel;
        this.verboseModeEnabled = verboseModeEnabled;
        this.prefix = prefix;
    }

    @Override
    public void debug(@Nonnull String message, Object ... parameters) {
        if (this.gradleLogger == null) {
            return;
        }
        this.gradleLogger.debug(this.formatMessage(message), parameters);
    }

    @Override
    public void info(@Nonnull String message, Object ... parameters) {
        this.logWithDefaultLevel(LogLevel.INFO, message, parameters);
    }

    @Override
    public void warn(@Nonnull String message, Object ... parameters) {
        this.logWithDefaultLevel(LogLevel.WARN, message, parameters);
    }

    private void logWithDefaultLevel(@Nonnull LogLevel defaultLoggingLevel, @Nonnull String message, Object ... parameters) {
        if (this.gradleLogger == null) {
            return;
        }
        if (this.verboseModeEnabled) {
            this.gradleLogger.log(this.loggingLevel, this.formatMessage(message), parameters);
        } else {
            this.gradleLogger.log(defaultLoggingLevel, this.formatMessage(message), parameters);
        }
    }

    @Nonnull
    private String formatMessage(@Nonnull String message) {
        return this.prefix == null ? message : this.prefix + message;
    }
}

