/*
 * Decompiled with CFR 0.152.
 */
package org.siouan.frontendgradleplugin.infrastructure.gradle;

import javax.annotation.Nonnull;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.TaskState;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistry;
import org.siouan.frontendgradleplugin.infrastructure.BeanRegistryException;
import org.siouan.frontendgradleplugin.infrastructure.gradle.FrontendExtension;
import org.siouan.frontendgradleplugin.infrastructure.gradle.adapter.GradleLoggerAdapter;

public class TaskLoggerConfigurer
implements TaskExecutionListener {
    private final BeanRegistry beanRegistry;
    private final FrontendExtension extension;

    public TaskLoggerConfigurer(BeanRegistry beanRegistry, FrontendExtension extension) {
        this.beanRegistry = beanRegistry;
        this.extension = extension;
    }

    public void beforeExecute(@Nonnull Task task) {
        task.getLogger().debug("Configuring logger for task '{}': verboseModeEnabled={}", (Object)task.getName(), this.extension.getVerboseModeEnabled().get());
        try {
            this.beanRegistry.getBean(GradleLoggerAdapter.class).init(task.getLogger(), this.resolveLogLevel(task), (Boolean)this.extension.getVerboseModeEnabled().get(), '[' + task.getName() + "] ");
        }
        catch (BeanRegistryException e) {
            throw new GradleException("Cannot get instance of bean registry", (Throwable)e);
        }
    }

    public void afterExecute(@Nonnull Task task, @Nonnull TaskState state) {
    }

    @Nonnull
    private LogLevel resolveLogLevel(@Nonnull Task task) {
        LogLevel loggingLevel = task.getLogging().getLevel();
        if (loggingLevel != null) {
            return loggingLevel;
        }
        loggingLevel = task.getProject().getLogging().getLevel();
        if (loggingLevel != null) {
            return loggingLevel;
        }
        return task.getProject().getGradle().getStartParameter().getLogLevel();
    }
}

